/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.ootp.codec;

import com.emc.codec.AbstractCodec;
import com.emc.codec.EncodeMetadata;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.opoo.ootp.codec.Codec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodecDecoder
extends Codec<CodecDecoder> {
    private static final Logger log = LoggerFactory.getLogger(CodecDecoder.class);
    private final List<AbstractCodec> allDecoders;

    public CodecDecoder() {
        ServiceLoader<AbstractCodec> load = ServiceLoader.load(AbstractCodec.class);
        this.allDecoders = StreamSupport.stream(load.spliterator(), false).sorted().collect(Collectors.toList());
    }

    public InputStream getDecodeStream(InputStream sourceStream, Map<String, String> completeMetaMap) {
        return this.getDecodeStream(sourceStream, completeMetaMap, null);
    }

    public InputStream getDecodeStream(InputStream sourceStream, Map<String, String> completeMetaMap, Map<String, Object> context) {
        Map<String, Object> codecProperties = this.buildCodecProperties(context);
        Map<AbstractCodec, EncodeMetadata> decoders = this.getDecoders(completeMetaMap);
        ArrayList<Map.Entry<AbstractCodec, EncodeMetadata>> list = new ArrayList<Map.Entry<AbstractCodec, EncodeMetadata>>(decoders.entrySet());
        for (int i = list.size() - 1; i >= 0; --i) {
            Map.Entry entry = (Map.Entry)list.get(i);
            AbstractCodec codec = (AbstractCodec)entry.getKey();
            EncodeMetadata metadata = (EncodeMetadata)entry.getValue();
            log.debug("Codec wrap input stream\uff1a{}", (Object)codec);
            sourceStream = codec.getDecodingStream(sourceStream, metadata, codecProperties);
        }
        ArrayList<EncodeMetadata> metadataList = new ArrayList<EncodeMetadata>(decoders.values());
        this.removeEncodeMetadata(completeMetaMap, metadataList);
        return sourceStream;
    }

    public OutputStream getDecodeStream(OutputStream targetStream, Map<String, String> completeMetaMap) {
        return this.getDecodeStream(targetStream, completeMetaMap, null);
    }

    public OutputStream getDecodeStream(OutputStream targetStream, Map<String, String> completeMetaMap, Map<String, Object> context) {
        Map<String, Object> codecProperties = this.buildCodecProperties(context);
        Map<AbstractCodec, EncodeMetadata> decoders = this.getDecoders(completeMetaMap);
        for (Map.Entry<AbstractCodec, EncodeMetadata> entry : decoders.entrySet()) {
            AbstractCodec codec = entry.getKey();
            EncodeMetadata metadata = entry.getValue();
            log.debug("Codec wrap output stream\uff1a{}", (Object)codec);
            targetStream = codec.getDecodingStream(targetStream, metadata, codecProperties);
        }
        ArrayList<EncodeMetadata> metadataList = new ArrayList<EncodeMetadata>(decoders.values());
        this.removeEncodeMetadata(completeMetaMap, metadataList);
        return targetStream;
    }

    public Map<AbstractCodec, EncodeMetadata> getDecoders(Map<String, String> completeMetaMap) {
        String[] encodeSpecs = CodecDecoder.getEncodeSpecs(completeMetaMap);
        LinkedHashMap<AbstractCodec, EncodeMetadata> decoders = new LinkedHashMap<AbstractCodec, EncodeMetadata>();
        for (String encodeSpec : encodeSpecs) {
            log.debug("\u67e5\u627e {} \u5bf9\u5e94\u7684 Codec", (Object)encodeSpec);
            AbstractCodec abstractCodec = this.allDecoders.stream().filter(codec -> codec.canDecode(encodeSpec)).findFirst().orElseThrow(() -> new RuntimeException("cannot decode the following encode list:\n" + Arrays.toString(encodeSpecs)));
            EncodeMetadata metadata = abstractCodec.createEncodeMetadata(encodeSpec, completeMetaMap);
            decoders.put(abstractCodec, metadata);
        }
        return decoders;
    }

    public void removeEncodeMetadata(Map<String, String> metaMap, List<EncodeMetadata> encodeMetaList) {
        for (int i = encodeMetaList.size() - 1; i >= 0; --i) {
            EncodeMetadata metadata = encodeMetaList.get(i);
            CodecDecoder.removeEncodeSpec(metaMap, metadata.getEncodeSpec());
            metaMap.keySet().removeAll(metadata.toMap().keySet());
            metaMap.remove(META_TRANSFORM_COMPLETE);
        }
    }

    public static void removeEncodeSpec(Map<String, String> metaMap, String encodeSpec) {
        String specString = metaMap.get(META_TRANSFORM_MODE);
        if (specString.equals(encodeSpec)) {
            metaMap.remove(META_TRANSFORM_MODE);
        } else {
            if (!specString.endsWith("," + encodeSpec)) {
                throw new UnsupportedOperationException("the encode chain does not include " + encodeSpec);
            }
            metaMap.put(META_TRANSFORM_MODE, specString.substring(0, specString.length() - (encodeSpec.length() + 1)));
        }
    }

    public static String[] getEncodeSpecs(Map<String, String> metaMap) {
        if (metaMap == null) {
            return null;
        }
        String specString = metaMap.get(META_TRANSFORM_MODE);
        if (specString == null) {
            return null;
        }
        return specString.split(",");
    }
}

