/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.ootp.codec;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.opoo.ootp.codec.encryption.EncryptionException;

public abstract class Codec<T extends Codec> {
    public static final String ATTR_CONTEXT = "org.opoo.ootp.codec.Codec.context";
    private static final String BASE_ID = new String(new byte[]{67, 77, 66});
    public static final String META_NAME_PREFIX = "x-" + BASE_ID.toLowerCase() + "-";
    public static final String META_TRANSFORM_MODE = META_NAME_PREFIX + "transform-mode";
    public static final String META_TRANSFORM_COMPLETE = META_NAME_PREFIX + "transform-complete";
    private Map<String, Object> properties = new HashMap<String, Object>();

    public static <T> T getContextProperty(Map<String, Object> codecProperties, String key) {
        return Codec.getContextProperty(codecProperties, key, () -> new EncryptionException("\u5728\u914d\u7f6e\u6216\u8005\u8fc7\u7a0b\u53c2\u6570\u4e2d\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5c5e\u6027\uff1a" + key));
    }

    public static <T> T getContextProperty(Map<String, Object> codecProperties, String key, Supplier<? extends EncryptionException> notFoundException) {
        return (T)Optional.ofNullable(codecProperties).map(c -> c.get(key)).orElseThrow(notFoundException);
    }

    protected Map<String, Object> buildCodecProperties(Map<String, Object> context) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Optional.ofNullable(this.properties).ifPresent(map::putAll);
        Optional.ofNullable(context).ifPresent(map::putAll);
        return map;
    }

    public T withProperties(Map<String, Object> properties) {
        this.setProperties(properties);
        return (T)this;
    }

    public T withProperty(String name, Object value) {
        this.addProperty(name, value);
        return (T)this;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public void addProperty(String name, Object value) {
        this.properties.put(name, value);
    }
}

