/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.sun.security.ssl;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.security.AlgorithmConstraints;
import java.security.CryptoPrimitive;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import javax.crypto.SecretKey;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLHandshakeException;
import javax.security.auth.x500.X500Principal;
import org.openeuler.sun.security.ssl.Alert;
import org.openeuler.sun.security.ssl.CipherSuite;
import org.openeuler.sun.security.ssl.ConnectionContext;
import org.openeuler.sun.security.ssl.ContentType;
import org.openeuler.sun.security.ssl.HandshakeHash;
import org.openeuler.sun.security.ssl.HandshakeOutStream;
import org.openeuler.sun.security.ssl.HandshakeProducer;
import org.openeuler.sun.security.ssl.Plaintext;
import org.openeuler.sun.security.ssl.ProtocolVersion;
import org.openeuler.sun.security.ssl.RandomCookie;
import org.openeuler.sun.security.ssl.Record;
import org.openeuler.sun.security.ssl.SSLAlgorithmConstraints;
import org.openeuler.sun.security.ssl.SSLConfiguration;
import org.openeuler.sun.security.ssl.SSLConsumer;
import org.openeuler.sun.security.ssl.SSLContextImpl;
import org.openeuler.sun.security.ssl.SSLCredentials;
import org.openeuler.sun.security.ssl.SSLExtension;
import org.openeuler.sun.security.ssl.SSLHandshake;
import org.openeuler.sun.security.ssl.SSLKeyDerivation;
import org.openeuler.sun.security.ssl.SSLKeyExchange;
import org.openeuler.sun.security.ssl.SSLLogger;
import org.openeuler.sun.security.ssl.SSLPossession;
import org.openeuler.sun.security.ssl.SSLSessionImpl;
import org.openeuler.sun.security.ssl.SignatureScheme;
import org.openeuler.sun.security.ssl.SupportedGroupsExtension;
import org.openeuler.sun.security.ssl.TransportContext;
import org.openeuler.sun.security.ssl.Utilities;

abstract class HandshakeContext
implements ConnectionContext {
    static final boolean allowUnsafeRenegotiation = Utilities.getBooleanProperty("sun.security.ssl.allowUnsafeRenegotiation", false);
    static final boolean allowLegacyHelloMessages = Utilities.getBooleanProperty("sun.security.ssl.allowLegacyHelloMessages", true);
    LinkedHashMap<Byte, SSLConsumer> handshakeConsumers;
    final HashMap<Byte, HandshakeProducer> handshakeProducers;
    final SSLContextImpl sslContext;
    final TransportContext conContext;
    final SSLConfiguration sslConfig;
    final List<ProtocolVersion> activeProtocols;
    final List<CipherSuite> activeCipherSuites;
    final AlgorithmConstraints algorithmConstraints;
    final ProtocolVersion maximumActiveProtocol;
    final HandshakeOutStream handshakeOutput;
    final HandshakeHash handshakeHash;
    SSLSessionImpl handshakeSession;
    boolean handshakeFinished;
    boolean kickstartMessageDelivered;
    boolean isResumption;
    SSLSessionImpl resumingSession;
    final Queue<Map.Entry<Byte, ByteBuffer>> delegatedActions;
    volatile boolean taskDelegated = false;
    volatile Exception delegatedThrown = null;
    ProtocolVersion negotiatedProtocol;
    CipherSuite negotiatedCipherSuite;
    boolean t12WithGMCipherSuite;
    final List<SSLPossession> handshakePossessions;
    final List<SSLCredentials> handshakeCredentials;
    SSLKeyDerivation handshakeKeyDerivation;
    SSLKeyExchange handshakeKeyExchange;
    SecretKey baseReadSecret;
    SecretKey baseWriteSecret;
    int clientHelloVersion;
    String applicationProtocol;
    RandomCookie clientHelloRandom;
    RandomCookie serverHelloRandom;
    byte[] certRequestContext;
    final Map<SSLExtension, SSLExtension.SSLExtensionSpec> handshakeExtensions;
    int maxFragmentLength;
    List<SignatureScheme> localSupportedSignAlgs;
    List<SignatureScheme> peerRequestedSignatureSchemes;
    List<SignatureScheme> peerRequestedCertSignSchemes;
    X500Principal[] peerSupportedAuthorities = null;
    List<SupportedGroupsExtension.NamedGroup> clientRequestedNamedGroups;
    SupportedGroupsExtension.NamedGroup serverSelectedNamedGroup;
    List<SNIServerName> requestedServerNames;
    SNIServerName negotiatedServerName;
    boolean staplingActive = false;

    protected HandshakeContext(SSLContextImpl sslContext, TransportContext conContext) throws IOException {
        this.sslContext = sslContext;
        this.conContext = conContext;
        this.sslConfig = (SSLConfiguration)conContext.sslConfig.clone();
        this.algorithmConstraints = new SSLAlgorithmConstraints(this.sslConfig.userSpecifiedAlgorithmConstraints);
        this.activeProtocols = HandshakeContext.getActiveProtocols(this.sslConfig.enabledProtocols, this.sslConfig.enabledCipherSuites, this.algorithmConstraints);
        if (this.activeProtocols.isEmpty()) {
            throw new SSLHandshakeException("No appropriate protocol (protocol is disabled or cipher suites are inappropriate)");
        }
        ProtocolVersion maximumVersion = ProtocolVersion.NONE;
        for (ProtocolVersion pv : this.activeProtocols) {
            if (maximumVersion != ProtocolVersion.NONE && pv.compare(maximumVersion) <= 0) continue;
            maximumVersion = pv;
        }
        this.maximumActiveProtocol = maximumVersion;
        this.activeCipherSuites = HandshakeContext.getActiveCipherSuites(this.activeProtocols, this.sslConfig.enabledCipherSuites, this.algorithmConstraints);
        if (this.activeCipherSuites.isEmpty()) {
            throw new SSLHandshakeException("No appropriate cipher suite");
        }
        this.handshakeConsumers = new LinkedHashMap();
        this.handshakeProducers = new HashMap();
        this.handshakeHash = conContext.inputRecord.handshakeHash;
        this.handshakeOutput = new HandshakeOutStream(conContext.outputRecord);
        this.handshakeFinished = false;
        this.kickstartMessageDelivered = false;
        this.delegatedActions = new LinkedList<Map.Entry<Byte, ByteBuffer>>();
        this.handshakeExtensions = new HashMap<SSLExtension, SSLExtension.SSLExtensionSpec>();
        this.handshakePossessions = new LinkedList<SSLPossession>();
        this.handshakeCredentials = new LinkedList<SSLCredentials>();
        this.requestedServerNames = null;
        this.negotiatedServerName = null;
        this.negotiatedCipherSuite = conContext.cipherSuite;
        this.initialize();
    }

    protected HandshakeContext(TransportContext conContext) {
        this.sslContext = conContext.sslContext;
        this.conContext = conContext;
        this.sslConfig = conContext.sslConfig;
        this.negotiatedProtocol = conContext.protocolVersion;
        this.negotiatedCipherSuite = conContext.cipherSuite;
        this.handshakeOutput = new HandshakeOutStream(conContext.outputRecord);
        this.delegatedActions = new LinkedList<Map.Entry<Byte, ByteBuffer>>();
        this.handshakeConsumers = new LinkedHashMap();
        this.handshakeProducers = null;
        this.handshakeHash = null;
        this.activeProtocols = null;
        this.activeCipherSuites = null;
        this.algorithmConstraints = null;
        this.maximumActiveProtocol = null;
        this.handshakeExtensions = Collections.emptyMap();
        this.handshakePossessions = null;
        this.handshakeCredentials = null;
    }

    private void initialize() {
        ProtocolVersion outputHelloVersion;
        ProtocolVersion inputHelloVersion;
        if (this.conContext.isNegotiated) {
            inputHelloVersion = this.conContext.protocolVersion;
            outputHelloVersion = this.conContext.protocolVersion;
        } else if (this.activeProtocols.contains((Object)ProtocolVersion.SSL20Hello)) {
            inputHelloVersion = ProtocolVersion.SSL20Hello;
            outputHelloVersion = this.maximumActiveProtocol.useTLS13PlusSpec() ? this.maximumActiveProtocol : ProtocolVersion.SSL20Hello;
        } else {
            inputHelloVersion = this.maximumActiveProtocol;
            outputHelloVersion = this.maximumActiveProtocol;
        }
        this.conContext.inputRecord.setHelloVersion(inputHelloVersion);
        this.conContext.outputRecord.setHelloVersion(outputHelloVersion);
        if (!this.conContext.isNegotiated) {
            this.conContext.protocolVersion = this.maximumActiveProtocol;
        }
        this.conContext.outputRecord.setVersion(this.conContext.protocolVersion);
    }

    private static List<ProtocolVersion> getActiveProtocols(List<ProtocolVersion> enabledProtocols, List<CipherSuite> enabledCipherSuites, AlgorithmConstraints algorithmConstraints) {
        boolean enabledSSL20Hello = false;
        ArrayList<ProtocolVersion> protocols = new ArrayList<ProtocolVersion>(4);
        for (ProtocolVersion protocol : enabledProtocols) {
            if (!enabledSSL20Hello && protocol == ProtocolVersion.SSL20Hello) {
                enabledSSL20Hello = true;
                continue;
            }
            if (!algorithmConstraints.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), protocol.name, null)) continue;
            boolean found = false;
            EnumMap<SupportedGroupsExtension.NamedGroupType, Boolean> cachedStatus = new EnumMap<SupportedGroupsExtension.NamedGroupType, Boolean>(SupportedGroupsExtension.NamedGroupType.class);
            for (CipherSuite suite : enabledCipherSuites) {
                if (suite.isAvailable() && suite.supports(protocol)) {
                    if (!HandshakeContext.isActivatable(suite, algorithmConstraints, cachedStatus)) continue;
                    protocols.add(protocol);
                    found = true;
                    break;
                }
                if (!SSLLogger.isOn || !SSLLogger.isOn("verbose")) continue;
                SSLLogger.fine("Ignore unsupported cipher suite: " + (Object)((Object)suite) + " for " + (Object)((Object)protocol), new Object[0]);
            }
            if (found || !SSLLogger.isOn || !SSLLogger.isOn("handshake")) continue;
            SSLLogger.fine("No available cipher suite for " + (Object)((Object)protocol), new Object[0]);
        }
        if (!protocols.isEmpty()) {
            if (enabledSSL20Hello) {
                protocols.add(ProtocolVersion.SSL20Hello);
            }
            Collections.sort(protocols);
        }
        return Collections.unmodifiableList(protocols);
    }

    private static List<CipherSuite> getActiveCipherSuites(List<ProtocolVersion> enabledProtocols, List<CipherSuite> enabledCipherSuites, AlgorithmConstraints algorithmConstraints) {
        LinkedList<CipherSuite> suites = new LinkedList<CipherSuite>();
        if (enabledProtocols != null && !enabledProtocols.isEmpty()) {
            EnumMap<SupportedGroupsExtension.NamedGroupType, Boolean> cachedStatus = new EnumMap<SupportedGroupsExtension.NamedGroupType, Boolean>(SupportedGroupsExtension.NamedGroupType.class);
            for (CipherSuite suite : enabledCipherSuites) {
                if (!suite.isAvailable()) continue;
                boolean isSupported = false;
                for (ProtocolVersion protocol : enabledProtocols) {
                    if (!suite.supports(protocol) || !HandshakeContext.isActivatable(suite, algorithmConstraints, cachedStatus)) continue;
                    suites.add(suite);
                    isSupported = true;
                    break;
                }
                if (isSupported || !SSLLogger.isOn || !SSLLogger.isOn("verbose")) continue;
                SSLLogger.finest("Ignore unsupported cipher suite: " + (Object)((Object)suite), new Object[0]);
            }
        }
        return Collections.unmodifiableList(suites);
    }

    static byte getHandshakeType(TransportContext conContext, Plaintext plaintext) throws IOException {
        if (plaintext.contentType != ContentType.HANDSHAKE.id) {
            throw conContext.fatal(Alert.INTERNAL_ERROR, "Unexpected operation for record: " + plaintext.contentType);
        }
        if (plaintext.fragment == null || plaintext.fragment.remaining() < 4) {
            throw conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Invalid handshake message: insufficient data");
        }
        byte handshakeType = (byte)Record.getInt8(plaintext.fragment);
        int handshakeLen = Record.getInt24(plaintext.fragment);
        if (handshakeLen != plaintext.fragment.remaining()) {
            throw conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Invalid handshake message: insufficient handshake body");
        }
        return handshakeType;
    }

    void dispatch(byte handshakeType, Plaintext plaintext) throws IOException {
        if (this.conContext.transport.useDelegatedTask()) {
            boolean hasDelegated;
            boolean bl = hasDelegated = !this.delegatedActions.isEmpty();
            if (hasDelegated || handshakeType != SSLHandshake.FINISHED.id && handshakeType != SSLHandshake.KEY_UPDATE.id && handshakeType != SSLHandshake.NEW_SESSION_TICKET.id) {
                if (!hasDelegated) {
                    this.taskDelegated = false;
                    this.delegatedThrown = null;
                }
                ByteBuffer fragment = ByteBuffer.wrap(new byte[plaintext.fragment.remaining()]);
                fragment.put(plaintext.fragment);
                fragment = (ByteBuffer)fragment.rewind();
                this.delegatedActions.add(new AbstractMap.SimpleImmutableEntry<Byte, ByteBuffer>(handshakeType, fragment));
            } else {
                this.dispatch(handshakeType, plaintext.fragment);
            }
        } else {
            this.dispatch(handshakeType, plaintext.fragment);
        }
    }

    void dispatch(byte handshakeType, ByteBuffer fragment) throws IOException {
        SSLConsumer consumer = handshakeType == SSLHandshake.HELLO_REQUEST.id ? SSLHandshake.HELLO_REQUEST : this.handshakeConsumers.get(handshakeType);
        if (consumer == null) {
            throw this.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Unexpected handshake message: " + SSLHandshake.nameOf(handshakeType));
        }
        try {
            consumer.consume(this, fragment);
        }
        catch (UnsupportedOperationException unsoe) {
            throw this.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Unsupported handshake message: " + SSLHandshake.nameOf(handshakeType), unsoe);
        }
        catch (BufferOverflowException | BufferUnderflowException be) {
            throw this.conContext.fatal(Alert.DECODE_ERROR, "Illegal handshake message: " + SSLHandshake.nameOf(handshakeType), be);
        }
        this.handshakeHash.consume();
    }

    abstract void kickstart() throws IOException;

    boolean isNegotiable(CipherSuite cs) {
        return HandshakeContext.isNegotiable(this.activeCipherSuites, cs);
    }

    static final boolean isNegotiable(List<CipherSuite> proposed, CipherSuite cs) {
        return proposed.contains((Object)cs) && cs.isNegotiable();
    }

    static final boolean isNegotiable(List<CipherSuite> proposed, ProtocolVersion protocolVersion, CipherSuite cs) {
        return proposed.contains((Object)cs) && cs.isNegotiable() && cs.supports(protocolVersion);
    }

    boolean isNegotiable(ProtocolVersion protocolVersion) {
        return this.activeProtocols.contains((Object)protocolVersion);
    }

    void setVersion(ProtocolVersion protocolVersion) {
        this.conContext.protocolVersion = protocolVersion;
    }

    private static boolean isActivatable(CipherSuite suite, AlgorithmConstraints algorithmConstraints, Map<SupportedGroupsExtension.NamedGroupType, Boolean> cachedStatus) {
        if (algorithmConstraints.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), suite.name, null)) {
            if (suite.keyExchange == null) {
                return true;
            }
            SupportedGroupsExtension.NamedGroupType groupType = suite.keyExchange.groupType;
            if (groupType != SupportedGroupsExtension.NamedGroupType.NAMED_GROUP_NONE) {
                boolean available;
                Boolean checkedStatus = cachedStatus.get((Object)groupType);
                if (checkedStatus == null) {
                    available = SupportedGroupsExtension.SupportedGroups.isActivatable(algorithmConstraints, groupType);
                    cachedStatus.put(groupType, available);
                    if (!available && SSLLogger.isOn && SSLLogger.isOn("verbose")) {
                        SSLLogger.fine("No activated named group", new Object[0]);
                    }
                } else {
                    available = checkedStatus;
                }
                if (!available && SSLLogger.isOn && SSLLogger.isOn("verbose")) {
                    SSLLogger.fine("No active named group, ignore " + (Object)((Object)suite), new Object[0]);
                }
                return available;
            }
            return true;
        }
        if (SSLLogger.isOn && SSLLogger.isOn("verbose")) {
            SSLLogger.fine("Ignore disabled cipher suite: " + (Object)((Object)suite), new Object[0]);
        }
        return false;
    }

    List<SNIServerName> getRequestedServerNames() {
        if (this.requestedServerNames == null) {
            return Collections.emptyList();
        }
        return this.requestedServerNames;
    }
}

