/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.annotated.slim.backed;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Type;
import java.util.List;
import javax.enterprise.inject.spi.AnnotatedCallable;
import javax.enterprise.inject.spi.AnnotatedParameter;
import org.jboss.weld.annotated.slim.backed.BackedAnnotatedMember;
import org.jboss.weld.annotated.slim.backed.BackedAnnotatedParameter;
import org.jboss.weld.annotated.slim.backed.BackedAnnotatedType;
import org.jboss.weld.resources.SharedObjectCache;

public abstract class BackedAnnotatedCallable<X, E extends Executable>
extends BackedAnnotatedMember<X>
implements AnnotatedCallable<X> {
    private final List<AnnotatedParameter<X>> parameters;
    private final E executable;

    public BackedAnnotatedCallable(E executable, Type baseType, BackedAnnotatedType<X> declaringType, SharedObjectCache sharedObjectCache) {
        super(baseType, declaringType, sharedObjectCache);
        this.executable = executable;
        this.parameters = this.initParameters(executable, sharedObjectCache);
    }

    protected List<AnnotatedParameter<X>> initParameters(E member, SharedObjectCache sharedObjectCache) {
        return BackedAnnotatedParameter.forExecutable(member, this, sharedObjectCache);
    }

    public E getJavaMember() {
        return this.executable;
    }

    @Override
    public List<AnnotatedParameter<X>> getParameters() {
        return this.parameters;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        return ((Executable)this.executable).getAnnotation(annotationType);
    }

    @Override
    protected AnnotatedElement getAnnotatedElement() {
        return this.executable;
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return ((AccessibleObject)this.executable).isAnnotationPresent(annotationType);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.executable == null ? 0 : this.executable.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BackedAnnotatedCallable other = (BackedAnnotatedCallable)obj;
        return !(this.executable == null ? other.executable != null : !this.executable.equals(other.executable));
    }
}

