/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.gateway.impl.identity;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Objects;
import org.hyperledger.fabric.gateway.X509Identity;

public final class X509IdentityImpl
implements X509Identity {
    private final String mspId;
    private final X509Certificate certificate;
    private final PrivateKey privateKey;

    public X509IdentityImpl(String mspId, X509Certificate certificate, PrivateKey privateKey) {
        if (mspId == null) {
            throw new NullPointerException("mspId must not be null");
        }
        if (certificate == null) {
            throw new NullPointerException("certificate must not be null");
        }
        if (privateKey == null) {
            throw new NullPointerException("privateKey must not be null");
        }
        this.mspId = mspId;
        this.certificate = certificate;
        this.privateKey = privateKey;
    }

    @Override
    public String getMspId() {
        return this.mspId;
    }

    @Override
    public X509Certificate getCertificate() {
        return this.certificate;
    }

    @Override
    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof X509IdentityImpl)) {
            return false;
        }
        X509IdentityImpl that = (X509IdentityImpl)other;
        return Objects.equals(this.mspId, that.mspId) && Objects.equals(this.certificate, that.certificate) && Objects.equals(this.privateKey, that.privateKey);
    }

    public int hashCode() {
        return Objects.hash(this.mspId, this.certificate);
    }
}

