/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.gateway.impl.identity;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import java.util.stream.Collectors;
import org.hyperledger.fabric.gateway.impl.GatewayUtils;
import org.hyperledger.fabric.gateway.spi.WalletStore;

public final class FileSystemWalletStore
implements WalletStore {
    private static final String DATA_FILE_EXTENTION = ".id";
    private final Path storePath;

    public FileSystemWalletStore(Path storePath) throws IOException {
        this.storePath = storePath;
        if (!Files.isDirectory(storePath, new LinkOption[0])) {
            Files.createDirectories(storePath, new FileAttribute[0]);
        }
    }

    @Override
    public void remove(String label) throws IOException {
        Path dataPath = this.getPathForLabel(label);
        Files.deleteIfExists(dataPath);
    }

    private Path getPathForLabel(String label) {
        return this.storePath.resolve(label + DATA_FILE_EXTENTION);
    }

    @Override
    public InputStream get(String label) {
        try {
            return Files.newInputStream(this.getPathForLabel(label), new OpenOption[0]);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public Set<String> list() throws IOException {
        return Files.list(this.storePath).map(Path::getFileName).map(Path::toString).filter(this::isDataFile).map(this::getLabelForFile).collect(Collectors.toSet());
    }

    private boolean isDataFile(String fileName) {
        return fileName.endsWith(DATA_FILE_EXTENTION);
    }

    private String getLabelForFile(String fileName) {
        return fileName.substring(0, fileName.length() - DATA_FILE_EXTENTION.length());
    }

    @Override
    public void put(String label, InputStream data) throws IOException {
        Path dataPath = this.getPathForLabel(label);
        try (OutputStream fileOut = Files.newOutputStream(dataPath, new OpenOption[0]);
             BufferedOutputStream bufferedOut = new BufferedOutputStream(fileOut);){
            GatewayUtils.copy(data, bufferedOut);
            bufferedOut.flush();
        }
    }
}

