/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.gateway.impl.event;

import java.util.function.Consumer;
import org.hyperledger.fabric.gateway.impl.GatewayUtils;
import org.hyperledger.fabric.gateway.impl.event.ListenerSession;
import org.hyperledger.fabric.gateway.impl.event.PeerDisconnectEventSource;
import org.hyperledger.fabric.gateway.impl.event.PeerDisconnectEventSourceFactory;
import org.hyperledger.fabric.gateway.spi.PeerDisconnectEvent;
import org.hyperledger.fabric.sdk.Peer;

public final class PeerDisconnectListenerSession
implements ListenerSession {
    private final PeerDisconnectEventSource disconnectSource;
    private final Consumer<PeerDisconnectEvent> listener;

    public PeerDisconnectListenerSession(Peer peer, Consumer<PeerDisconnectEvent> listener) {
        this.disconnectSource = PeerDisconnectEventSourceFactory.getInstance().getPeerDisconnectEventSource(peer);
        this.listener = listener;
        this.disconnectSource.addDisconnectListener(listener);
    }

    @Override
    public void close() {
        this.disconnectSource.removeDisconnectListener(this.listener);
    }

    public String toString() {
        return GatewayUtils.toString(this, "disconnectSource=" + this.disconnectSource, "listener=" + this.listener);
    }
}

