/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.gateway.impl.event;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.hyperledger.fabric.gateway.impl.event.PeerDisconnectEventSource;
import org.hyperledger.fabric.gateway.impl.event.PeerDisconnectInterceptor;
import org.hyperledger.fabric.sdk.Peer;

public final class PeerDisconnectEventSourceFactory {
    private static final PeerDisconnectEventSourceFactory INSTANCE = new PeerDisconnectEventSourceFactory();
    private final Map<Peer, PeerDisconnectEventSource> eventSources = Collections.synchronizedMap(new WeakHashMap());

    public static PeerDisconnectEventSourceFactory getInstance() {
        return INSTANCE;
    }

    private PeerDisconnectEventSourceFactory() {
    }

    public PeerDisconnectEventSource getPeerDisconnectEventSource(Peer peer) {
        return this.eventSources.computeIfAbsent(peer, key -> new PeerDisconnectInterceptor(peer));
    }

    void setPeerDisconnectEventSource(Peer peer, PeerDisconnectEventSource eventSource) {
        PeerDisconnectEventSource previousValue = this.eventSources.put(peer, eventSource);
        if (previousValue != null) {
            previousValue.close();
        }
    }
}

