/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.gateway.impl.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import org.hyperledger.fabric.gateway.impl.event.PeerDisconnectEventSource;
import org.hyperledger.fabric.gateway.spi.PeerDisconnectEvent;

public final class CompositePeerDisconnectListener
implements AutoCloseable {
    private final Collection<PeerDisconnectEventSource> eventSources;
    private final Consumer<PeerDisconnectEvent> listener;

    public CompositePeerDisconnectListener(Consumer<PeerDisconnectEvent> listener, Collection<PeerDisconnectEventSource> eventSources) {
        this.eventSources = new ArrayList<PeerDisconnectEventSource>(eventSources);
        this.listener = listener;
        this.eventSources.forEach(eventSource -> eventSource.addDisconnectListener(listener));
    }

    @Override
    public synchronized void close() {
        this.eventSources.forEach(eventSource -> eventSource.removeDisconnectListener(this.listener));
        this.eventSources.clear();
    }
}

