/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.gateway.impl.event;

import java.util.function.Function;
import org.hyperledger.fabric.gateway.impl.event.BlockEventSource;
import org.hyperledger.fabric.gateway.impl.event.ChannelBlockEventSource;
import org.hyperledger.fabric.sdk.Channel;

public final class BlockEventSourceFactory {
    static final Function<Channel, BlockEventSource> DEFAULT_FACTORY_FN = ChannelBlockEventSource::new;
    private static final BlockEventSourceFactory INSTANCE = new BlockEventSourceFactory();
    private static Function<Channel, BlockEventSource> factoryFn = DEFAULT_FACTORY_FN;

    public static BlockEventSourceFactory getInstance() {
        return INSTANCE;
    }

    static void setFactoryFunction(Function<Channel, BlockEventSource> newFactoryFn) {
        factoryFn = newFactoryFn;
    }

    private BlockEventSourceFactory() {
    }

    public BlockEventSource newBlockEventSource(Channel channel) {
        return factoryFn.apply(channel);
    }
}

