/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.gateway.impl.commit;

import java.util.Collection;
import org.hyperledger.fabric.gateway.impl.commit.CommitStrategy;
import org.hyperledger.fabric.gateway.spi.PeerDisconnectEvent;
import org.hyperledger.fabric.sdk.BlockEvent;
import org.hyperledger.fabric.sdk.Peer;

public final class AnyCommitStrategy
implements CommitStrategy {
    private final Collection<Peer> peers;
    private int totalCount = 0;

    public AnyCommitStrategy(Collection<Peer> peers) {
        this.peers = peers;
    }

    @Override
    public Collection<Peer> getPeers() {
        return this.peers;
    }

    @Override
    public synchronized CommitStrategy.Result onEvent(BlockEvent.TransactionEvent event) {
        return CommitStrategy.Result.SUCCESS;
    }

    @Override
    public synchronized CommitStrategy.Result onError(PeerDisconnectEvent event) {
        ++this.totalCount;
        if (this.totalCount < this.peers.size()) {
            return CommitStrategy.Result.CONTINUE;
        }
        return CommitStrategy.Result.FAIL;
    }
}

