/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.gateway.impl.commit;

import java.util.Collection;
import org.hyperledger.fabric.gateway.impl.commit.CommitStrategy;
import org.hyperledger.fabric.gateway.spi.PeerDisconnectEvent;
import org.hyperledger.fabric.sdk.BlockEvent;
import org.hyperledger.fabric.sdk.Peer;

public final class AllCommitStrategy
implements CommitStrategy {
    private final Collection<Peer> peers;
    private int successCount = 0;
    private int totalCount = 0;

    public AllCommitStrategy(Collection<Peer> peers) {
        this.peers = peers;
    }

    @Override
    public Collection<Peer> getPeers() {
        return this.peers;
    }

    @Override
    public synchronized CommitStrategy.Result onEvent(BlockEvent.TransactionEvent event) {
        ++this.successCount;
        ++this.totalCount;
        return this.getResult();
    }

    @Override
    public synchronized CommitStrategy.Result onError(PeerDisconnectEvent event) {
        ++this.totalCount;
        return this.getResult();
    }

    private CommitStrategy.Result getResult() {
        if (this.totalCount < this.peers.size()) {
            return CommitStrategy.Result.CONTINUE;
        }
        if (this.successCount >= 1) {
            return CommitStrategy.Result.SUCCESS;
        }
        return CommitStrategy.Result.FAIL;
    }
}

