/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.c;

import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.c.info.NativeCodeInfo;
import com.oracle.svm.hosted.c.query.QueryResultParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.graalvm.compiler.options.Option;

public final class CAnnotationProcessorCache {
    private static final String FILE_EXTENSION = ".cap";
    private File cache;

    public CAnnotationProcessorCache() {
        if (Options.UseCAPCache.getValue().booleanValue() || Options.NewCAPCache.getValue().booleanValue()) {
            if (Options.CAPCacheDir.getValue() == null || Options.CAPCacheDir.getValue().isEmpty()) {
                throw UserError.abort("Path to C Annotation Processor Cache must be specified using " + SubstrateOptionsParser.commandArgument(Options.CAPCacheDir, "") + " when the option " + SubstrateOptionsParser.commandArgument(Options.UseCAPCache, "+") + " or " + SubstrateOptionsParser.commandArgument(Options.NewCAPCache, "+") + " is used.");
            }
            Path cachePath = FileSystems.getDefault().getPath(Options.CAPCacheDir.getValue(), new String[0]).toAbsolutePath();
            this.cache = cachePath.toFile();
            if (!this.cache.exists()) {
                try {
                    this.cache = Files.createDirectories(cachePath, new FileAttribute[0]).toFile();
                }
                catch (IOException e) {
                    throw UserError.abort("Could not create C Annotation Processor Cache directory: " + e.getMessage());
                }
            } else {
                if (!this.cache.isDirectory()) {
                    throw UserError.abort("Path to C Annotation Processor Cache is not a directory");
                }
                if (Options.NewCAPCache.getValue().booleanValue()) {
                    this.clearCache();
                }
            }
        }
    }

    private static String toPath(NativeCodeInfo nativeCodeInfo) {
        return nativeCodeInfo.getName().replaceAll("\\W", "_").concat(FILE_EXTENSION);
    }

    public void get(NativeLibraries nativeLibs, NativeCodeInfo nativeCodeInfo) {
        File file = new File(this.cache, CAnnotationProcessorCache.toPath(nativeCodeInfo));
        try (FileInputStream fis = new FileInputStream(file);){
            QueryResultParser.parse(nativeLibs, nativeCodeInfo, fis);
        }
        catch (IOException e) {
            throw UserError.abort("Could not load CAPCache file. Ensure that options " + Options.UseCAPCache.getName() + " and " + Options.NewCAPCache + " are used on the same version of your application. Raw error: " + e.getMessage());
        }
    }

    public void put(NativeCodeInfo nativeCodeInfo, List<String> lines) {
        if (!Options.NewCAPCache.getValue().booleanValue()) {
            return;
        }
        File cachedItem = new File(this.cache, CAnnotationProcessorCache.toPath(nativeCodeInfo));
        try (FileWriter writer = new FileWriter(cachedItem, true);){
            for (String line : lines) {
                writer.write(line);
                writer.write(13);
            }
            return;
        }
        catch (IOException e) {
            throw VMError.shouldNotReachHere("Invalid CAnnotation Processor Cache item:" + cachedItem.toString());
        }
    }

    private void clearCache() {
        try {
            final Path cachePath = this.cache.toPath();
            Files.walkFileTree(cachePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    assert (file.toString().endsWith(CAnnotationProcessorCache.FILE_EXTENSION));
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    if (!dir.equals(cachePath)) {
                        Files.delete(dir);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException eio) {
            throw VMError.shouldNotReachHere(eio);
        }
    }

    public static class Options {
        @Option(help={"Indicate the C Annotation Processor to use previously cached native information when generating C Type information."})
        public static final HostedOptionKey<Boolean> UseCAPCache = new HostedOptionKey<Boolean>(false);
        @Option(help={"Create a C Annotation Processor Cache. Will erase any previous cache at that same location."})
        public static final HostedOptionKey<Boolean> NewCAPCache = new HostedOptionKey<Boolean>(false);
        @Option(help={"Directory where information generated by the CAnnotation Processor are cached."})
        public static final HostedOptionKey<String> CAPCacheDir = new HostedOptionKey<String>("");
        @Option(help={"Exit image generation after C Annotation Processor Cache creation."})
        public static final HostedOptionKey<Boolean> ExitAfterCAPCache = new HostedOptionKey<Boolean>(false);
    }
}

