/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.cmd;

import java.util.List;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.api.Job;
import org.flowable.job.api.JobInfo;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.impl.JobQueryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnacquireOwnedJobsCmd
implements Command<Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnacquireOwnedJobsCmd.class);
    protected final JobServiceConfiguration jobServiceConfiguration;
    protected final String lockOwner;
    protected final String tenantId;

    public UnacquireOwnedJobsCmd(String lockOwner, String tenantId, JobServiceConfiguration jobServiceConfiguration) {
        this.lockOwner = lockOwner;
        this.tenantId = tenantId;
        this.jobServiceConfiguration = jobServiceConfiguration;
    }

    public Void execute(CommandContext commandContext) {
        JobQueryImpl jobQuery = new JobQueryImpl(commandContext, this.jobServiceConfiguration);
        jobQuery.lockOwner(this.lockOwner);
        if (this.tenantId != null) {
            if (!this.tenantId.isEmpty()) {
                jobQuery.jobTenantId(this.tenantId);
            } else {
                jobQuery.jobWithoutTenantId();
            }
        }
        List<Job> jobs = this.jobServiceConfiguration.getJobEntityManager().findJobsByQueryCriteria(jobQuery);
        for (Job job : jobs) {
            this.logJobUnlocking(job);
            this.jobServiceConfiguration.getJobManager().unacquire((JobInfo)job);
        }
        return null;
    }

    protected void logJobUnlocking(Job job) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Unacquiring job {} with owner {} and tenantId {}", new Object[]{job, this.lockOwner, this.tenantId});
        }
    }
}

