/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.bpmn.converter.child;

import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.converter.child.BaseChildElementParser;
import org.flowable.bpmn.converter.util.BpmnXMLUtil;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.FormProperty;
import org.flowable.bpmn.model.FormValue;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.bpmn.model.UserTask;

public class FormPropertyParser
extends BaseChildElementParser {
    @Override
    public String getElementName() {
        return "formProperty";
    }

    @Override
    public boolean accepts(BaseElement element) {
        return element instanceof UserTask || element instanceof StartEvent;
    }

    @Override
    public void parseChildElement(XMLStreamReader xtr, BaseElement parentElement, BpmnModel model) throws Exception {
        if (!this.accepts(parentElement)) {
            return;
        }
        FormProperty property = new FormProperty();
        BpmnXMLUtil.addXMLLocation((BaseElement)property, xtr);
        property.setId(xtr.getAttributeValue(null, "id"));
        property.setName(xtr.getAttributeValue(null, "name"));
        property.setType(xtr.getAttributeValue(null, "type"));
        property.setVariable(xtr.getAttributeValue(null, "variable"));
        property.setExpression(xtr.getAttributeValue(null, "expression"));
        property.setDefaultExpression(xtr.getAttributeValue(null, "default"));
        property.setDatePattern(xtr.getAttributeValue(null, "datePattern"));
        if (StringUtils.isNotEmpty((CharSequence)xtr.getAttributeValue(null, "required"))) {
            property.setRequired(Boolean.valueOf(xtr.getAttributeValue(null, "required")).booleanValue());
        }
        if (StringUtils.isNotEmpty((CharSequence)xtr.getAttributeValue(null, "readable"))) {
            property.setReadable(Boolean.valueOf(xtr.getAttributeValue(null, "readable")).booleanValue());
        }
        if (StringUtils.isNotEmpty((CharSequence)xtr.getAttributeValue(null, "writable"))) {
            property.setWriteable(Boolean.valueOf(xtr.getAttributeValue(null, "writable")).booleanValue());
        }
        boolean readyWithFormProperty = false;
        try {
            while (!readyWithFormProperty && xtr.hasNext()) {
                xtr.next();
                if (xtr.isStartElement() && "value".equalsIgnoreCase(xtr.getLocalName())) {
                    FormValue value = new FormValue();
                    BpmnXMLUtil.addXMLLocation((BaseElement)value, xtr);
                    value.setId(xtr.getAttributeValue(null, "id"));
                    value.setName(xtr.getAttributeValue(null, "name"));
                    property.getFormValues().add(value);
                    continue;
                }
                if (!xtr.isEndElement() || !this.getElementName().equalsIgnoreCase(xtr.getLocalName())) continue;
                readyWithFormProperty = true;
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error parsing form properties child elements", (Throwable)e);
        }
        if (parentElement instanceof UserTask) {
            ((UserTask)parentElement).getFormProperties().add(property);
        } else {
            ((StartEvent)parentElement).getFormProperties().add(property);
        }
    }
}

