/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.web.handler;

import java.util.Map;
import java.util.Objects;
import org.apache.shenyu.common.utils.JsonUtils;
import org.apache.shenyu.common.utils.ThreadShare;
import org.apache.shenyu.plugin.api.result.ShenyuResultWrap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.web.ErrorProperties;
import org.springframework.boot.autoconfigure.web.ResourceProperties;
import org.springframework.boot.autoconfigure.web.reactive.error.DefaultErrorWebExceptionHandler;
import org.springframework.boot.web.reactive.error.ErrorAttributes;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.web.reactive.function.server.RequestPredicate;
import org.springframework.web.reactive.function.server.RequestPredicates;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.server.ResponseStatusException;

public class GlobalErrorHandler
extends DefaultErrorWebExceptionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(GlobalErrorHandler.class);
    private static final ThreadShare<Integer> HTTP_STATUS_HOLDER = new ThreadShare();

    public GlobalErrorHandler(ErrorAttributes errorAttributes, ResourceProperties resourceProperties, ErrorProperties errorProperties, ApplicationContext applicationContext) {
        super(errorAttributes, resourceProperties, errorProperties, applicationContext);
    }

    protected Map<String, Object> getErrorAttributes(ServerRequest request, boolean includeStackTrace) {
        this.logError(request);
        return this.response(request);
    }

    protected RouterFunction<ServerResponse> getRoutingFunction(ErrorAttributes errorAttributes) {
        return RouterFunctions.route((RequestPredicate)RequestPredicates.all(), arg_0 -> ((GlobalErrorHandler)this).renderErrorResponse(arg_0));
    }

    protected int getHttpStatus(Map<String, Object> errorAttributes) {
        Integer status = (Integer)HTTP_STATUS_HOLDER.getRemove();
        return Objects.nonNull(status) ? status.intValue() : HttpStatus.INTERNAL_SERVER_ERROR.value();
    }

    private Map<String, Object> response(ServerRequest request) {
        Throwable ex = this.getError(request);
        HttpStatus httpStatus = HttpStatus.INTERNAL_SERVER_ERROR;
        if (ex instanceof ResponseStatusException) {
            httpStatus = ((ResponseStatusException)ex).getStatus();
        }
        HTTP_STATUS_HOLDER.set((Object)httpStatus.value());
        Object error = ShenyuResultWrap.error((int)httpStatus.value(), (String)httpStatus.getReasonPhrase(), (Object)ex.getMessage());
        return JsonUtils.toMap((Object)error);
    }

    private void logError(ServerRequest request) {
        Throwable ex = this.getError(request);
        LOG.error(request.exchange().getLogPrefix() + this.formatError(ex, request));
    }

    private String formatError(Throwable ex, ServerRequest request) {
        String reason = ex.getClass().getSimpleName() + ": " + ex.getMessage();
        return "Resolved [" + reason + "] for HTTP " + request.methodName() + " " + request.path();
    }
}

