/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.web.filter;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class ExcludeFilter
implements WebFilter {
    private static final AntPathMatcher MATCHER = new AntPathMatcher();
    private List<String> paths;

    public ExcludeFilter(List<String> paths) {
        this.paths = paths;
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        ServerHttpRequest request = exchange.getRequest();
        String path = request.getURI().getPath();
        Set<String> excludedPaths = Collections.unmodifiableSet(new HashSet<String>(this.paths));
        boolean match = excludedPaths.stream().anyMatch(url -> ExcludeFilter.reg(url, path));
        if (match) {
            ServerHttpResponse response = exchange.getResponse();
            response.setStatusCode(HttpStatus.OK);
            return Mono.empty();
        }
        return chain.filter(exchange);
    }

    private static boolean reg(String pattern, String path) {
        return MATCHER.match(pattern, path);
    }
}

