/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.web.filter;

import org.apache.shenyu.common.config.ShenyuConfig;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.cors.reactive.CorsUtils;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class CrossFilter
implements WebFilter {
    private final ShenyuConfig.CrossFilterConfig filterConfig;

    public CrossFilter(ShenyuConfig.CrossFilterConfig filterConfig) {
        this.filterConfig = filterConfig;
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        ServerHttpRequest request = exchange.getRequest();
        if (CorsUtils.isCorsRequest((ServerHttpRequest)request)) {
            ServerHttpResponse response = exchange.getResponse();
            HttpHeaders headers = response.getHeaders();
            headers.add("Access-Control-Allow-Origin", this.filterConfig.getAllowedOrigin());
            headers.add("Access-Control-Allow-Methods", this.filterConfig.getAllowedMethods());
            headers.add("Access-Control-Max-Age", this.filterConfig.getMaxAge());
            headers.add("Access-Control-Allow-Headers", this.filterConfig.getAllowedHeaders());
            headers.add("Access-Control-Expose-Headers", this.filterConfig.getAllowedExpose());
            headers.add("Access-Control-Allow-Credentials", String.valueOf(this.filterConfig.isAllowCredentials()));
            if (request.getMethod() == HttpMethod.OPTIONS) {
                response.setStatusCode(HttpStatus.OK);
                return Mono.empty();
            }
        }
        return chain.filter(exchange);
    }
}

