/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.disruptor;

import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.IgnoreExceptionHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.WorkHandler;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.shenyu.disruptor.consumer.QueueConsumer;
import org.apache.shenyu.disruptor.consumer.QueueConsumerFactory;
import org.apache.shenyu.disruptor.event.DisruptorEventFactory;
import org.apache.shenyu.disruptor.provider.DisruptorProvider;
import org.apache.shenyu.disruptor.thread.DisruptorThreadFactory;

public class DisruptorProviderManage<T> {
    public static final Integer DEFAULT_SIZE = 16384;
    private static final Integer DEFAULT_CONSUMER_SIZE = Runtime.getRuntime().availableProcessors() << 1;
    private final Integer size;
    private DisruptorProvider<T> provider;
    private Integer consumerSize;
    private QueueConsumerFactory<T> consumerFactory;
    private ExecutorService executor;

    public DisruptorProviderManage(QueueConsumerFactory<T> consumerFactory, Integer ringBufferSize) {
        this(consumerFactory, DEFAULT_CONSUMER_SIZE, ringBufferSize);
    }

    public DisruptorProviderManage(QueueConsumerFactory<T> consumerFactory) {
        this(consumerFactory, DEFAULT_CONSUMER_SIZE, DEFAULT_SIZE);
    }

    public DisruptorProviderManage(QueueConsumerFactory<T> consumerFactory, int consumerSize, int ringBufferSize) {
        this.consumerFactory = consumerFactory;
        this.size = ringBufferSize;
        this.consumerSize = consumerSize;
        this.executor = new ThreadPoolExecutor(consumerSize, consumerSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), DisruptorThreadFactory.create("shenyu_disruptor_consumer_", false), new ThreadPoolExecutor.AbortPolicy());
    }

    public void startup() {
        Disruptor disruptor = new Disruptor(new DisruptorEventFactory(), this.size.intValue(), DisruptorThreadFactory.create("shenyu_disruptor_provider_" + this.consumerFactory.fixName(), false), ProducerType.MULTI, (WaitStrategy)new BlockingWaitStrategy());
        WorkHandler[] consumers = new QueueConsumer[this.consumerSize.intValue()];
        for (int i = 0; i < this.consumerSize; ++i) {
            consumers[i] = new QueueConsumer<T>(this.executor, this.consumerFactory);
        }
        disruptor.handleEventsWithWorkerPool(consumers);
        disruptor.setDefaultExceptionHandler((ExceptionHandler)new IgnoreExceptionHandler());
        disruptor.start();
        RingBuffer ringBuffer = disruptor.getRingBuffer();
        this.provider = new DisruptorProvider(ringBuffer, disruptor);
    }

    public DisruptorProvider<T> getProvider() {
        return this.provider;
    }
}

