/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.utils;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.shenyu.common.utils.ThreadShare;

public final class ThreadShareUtils {
    private static final String DEFAULT_SHARE = "default-thread-share";
    private static final Map<ThreadShare<Object>, Object> SHARE_MAPPING = new ConcurrentHashMap<ThreadShare<Object>, Object>();

    private static ThreadShare<Object> getShareByName(String name) {
        return new ThreadShare<Object>(name);
    }

    public static <T> void put(T data) {
        ThreadShareUtils.put(DEFAULT_SHARE, data);
    }

    public static <T> void put(String name, T data) {
        SHARE_MAPPING.put(ThreadShareUtils.getShareByName(name), data);
    }

    public static <T> T get() {
        return ThreadShareUtils.get(DEFAULT_SHARE);
    }

    public static <T> T get(String name) {
        ThreadShare<Object> share = ThreadShareUtils.getShareByName(name);
        if (!SHARE_MAPPING.containsKey(share)) {
            return null;
        }
        Object data = SHARE_MAPPING.get(share);
        return (T)data;
    }

    public static <T> T getRemove() {
        return ThreadShareUtils.getRemove(DEFAULT_SHARE);
    }

    public static <T> T getRemove(String name) {
        ThreadShare<Object> share = ThreadShareUtils.getShareByName(name);
        if (!SHARE_MAPPING.containsKey(share)) {
            return null;
        }
        Object data = SHARE_MAPPING.remove(share);
        return (T)data;
    }
}

