/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.client.springmvc.init;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.client.core.disruptor.ShenyuClientRegisterEventPublisher;
import org.apache.shenyu.client.springmvc.annotation.ShenyuSpringMvcClient;
import org.apache.shenyu.register.client.api.ShenyuClientRegisterRepository;
import org.apache.shenyu.register.common.config.ShenyuRegisterCenterConfig;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Controller;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;

public class SpringMvcClientBeanPostProcessor
implements BeanPostProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(SpringMvcClientBeanPostProcessor.class);
    private final ShenyuClientRegisterEventPublisher publisher = ShenyuClientRegisterEventPublisher.getInstance();
    private final ExecutorService executorService;
    private final String contextPath;
    private final String appName;
    private final Boolean isFull;

    public SpringMvcClientBeanPostProcessor(ShenyuRegisterCenterConfig config, ShenyuClientRegisterRepository shenyuClientRegisterRepository) {
        String registerType = config.getRegisterType();
        String serverLists = config.getServerLists();
        Properties props = config.getProps();
        int port = Integer.parseInt(props.getProperty("port"));
        if (StringUtils.isBlank((CharSequence)registerType) || StringUtils.isBlank((CharSequence)serverLists) || port <= 0) {
            String errorMsg = "http register param must config the registerType , serverLists and port must > 0";
            LOG.error(errorMsg);
            throw new RuntimeException(errorMsg);
        }
        this.appName = props.getProperty("appName");
        this.contextPath = props.getProperty("contextPath");
        if (StringUtils.isBlank((CharSequence)this.appName) && StringUtils.isBlank((CharSequence)this.contextPath)) {
            String errorMsg = "http register param must config the appName or contextPath";
            LOG.error(errorMsg);
            throw new RuntimeException(errorMsg);
        }
        this.isFull = Boolean.parseBoolean(props.getProperty("isFull", "false"));
        this.executorService = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("shenyu-spring-mvc-client-thread-pool-%d").build());
        this.publisher.start(shenyuClientRegisterRepository);
    }

    public Object postProcessAfterInitialization(@NonNull Object bean, @NonNull String beanName) throws BeansException {
        if (this.isFull.booleanValue()) {
            return bean;
        }
        Controller controller = (Controller)AnnotationUtils.findAnnotation(bean.getClass(), Controller.class);
        RequestMapping requestMapping = (RequestMapping)AnnotationUtils.findAnnotation(bean.getClass(), RequestMapping.class);
        if (controller != null || requestMapping != null) {
            Method[] methods;
            ShenyuSpringMvcClient clazzAnnotation = (ShenyuSpringMvcClient)AnnotationUtils.findAnnotation(bean.getClass(), ShenyuSpringMvcClient.class);
            String prePath = "";
            if (Objects.isNull(clazzAnnotation)) {
                return bean;
            }
            if (clazzAnnotation.path().indexOf("*") > 1) {
                this.publisher.publishEvent((Object)this.buildMetaDataDTO(clazzAnnotation, prePath));
                return bean;
            }
            prePath = clazzAnnotation.path();
            for (Method method : methods = ReflectionUtils.getUniqueDeclaredMethods(bean.getClass())) {
                ShenyuSpringMvcClient shenyuSpringMvcClient = (ShenyuSpringMvcClient)AnnotationUtils.findAnnotation((Method)method, ShenyuSpringMvcClient.class);
                if (!Objects.nonNull(shenyuSpringMvcClient)) continue;
                this.publisher.publishEvent((Object)this.buildMetaDataDTO(shenyuSpringMvcClient, prePath));
            }
        }
        return bean;
    }

    private MetaDataRegisterDTO buildMetaDataDTO(ShenyuSpringMvcClient shenyuSpringMvcClient, String prePath) {
        String contextPath = this.contextPath;
        String appName = this.appName;
        String path = StringUtils.isEmpty((CharSequence)contextPath) ? prePath + shenyuSpringMvcClient.path() : contextPath + prePath + shenyuSpringMvcClient.path();
        String desc = shenyuSpringMvcClient.desc();
        String configRuleName = shenyuSpringMvcClient.ruleName();
        String ruleName = StringUtils.isBlank((CharSequence)configRuleName) ? path : configRuleName;
        return MetaDataRegisterDTO.builder().contextPath(contextPath).appName(appName).path(path).pathDesc(desc).rpcType(shenyuSpringMvcClient.rpcType()).enabled(shenyuSpringMvcClient.enabled()).ruleName(ruleName).registerMetaData(shenyuSpringMvcClient.registerMetaData()).build();
    }
}

