/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.client.springmvc.init;

import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.client.core.disruptor.ShenyuClientRegisterEventPublisher;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.utils.IpUtils;
import org.apache.shenyu.register.common.config.ShenyuRegisterCenterConfig;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.apache.shenyu.register.common.dto.URIRegisterDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.lang.NonNull;

public class ContextRegisterListener
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(ContextRegisterListener.class);
    private ShenyuClientRegisterEventPublisher publisher = ShenyuClientRegisterEventPublisher.getInstance();
    private final AtomicBoolean registered = new AtomicBoolean(false);
    private String contextPath;
    private String appName;
    private String host;
    private Integer port;
    private final Boolean isFull;

    public ContextRegisterListener(ShenyuRegisterCenterConfig config) {
        String contextPath;
        Properties props = config.getProps();
        this.isFull = Boolean.parseBoolean(props.getProperty("isFull", "false"));
        this.contextPath = contextPath = props.getProperty("contextPath");
        if (this.isFull.booleanValue()) {
            if (StringUtils.isBlank((CharSequence)contextPath)) {
                String errorMsg = "http register param must config the contextPath";
                LOG.error(errorMsg);
                throw new RuntimeException(errorMsg);
            }
            this.contextPath = contextPath + "/**";
        }
        int port = Integer.parseInt(props.getProperty("port"));
        this.appName = props.getProperty("appName");
        this.host = props.getProperty("host");
        this.port = port;
    }

    public void onApplicationEvent(@NonNull ContextRefreshedEvent contextRefreshedEvent) {
        if (!this.registered.compareAndSet(false, true)) {
            return;
        }
        if (this.isFull.booleanValue()) {
            this.publisher.publishEvent((Object)this.buildMetaDataDTO());
        }
        this.publisher.publishEvent((Object)this.buildURIRegisterDTO());
    }

    private URIRegisterDTO buildURIRegisterDTO() {
        String host = IpUtils.isCompleteHost((String)this.host) ? this.host : IpUtils.getHost((String)this.host);
        return URIRegisterDTO.builder().contextPath(this.contextPath).appName(this.appName).host(host).port(this.port).rpcType(RpcTypeEnum.HTTP.getName()).build();
    }

    private MetaDataRegisterDTO buildMetaDataDTO() {
        String contextPath = this.contextPath;
        String appName = this.appName;
        return MetaDataRegisterDTO.builder().contextPath(contextPath).appName(appName).path(contextPath).rpcType(RpcTypeEnum.HTTP.getName()).enabled(true).ruleName(contextPath).build();
    }
}

