/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.repository.standalone.jdbc.sql;

import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import lombok.Generated;
import org.apache.shardingsphere.mode.repository.standalone.jdbc.sql.JDBCRepositorySQL;

public final class JDBCRepositorySQLLoader {
    private static final String ROOT_DIRECTORY = "sql";
    private static final String FILE_EXTENSION = ".xml";
    private static final Collection<String> JAR_URL_PROTOCOLS = new HashSet<String>(Arrays.asList("jar", "war", "zip", "wsjar", "vfszip"));

    public static JDBCRepositorySQL load(String type) {
        URL resource;
        Enumeration<URL> resources = Thread.currentThread().getContextClassLoader().getResources(ROOT_DIRECTORY);
        if (null == resources) {
            return null;
        }
        JDBCRepositorySQL result = null;
        while (resources.hasMoreElements() && (null == (result = JAR_URL_PROTOCOLS.contains((resource = resources.nextElement()).getProtocol()) ? JDBCRepositorySQLLoader.loadFromJar(resource, type) : JDBCRepositorySQLLoader.loadFromDirectory(resource, type)) || result.isDefault())) {
        }
        return result;
    }

    private static JDBCRepositorySQL loadFromDirectory(URL url, final String type) throws URISyntaxException, IOException {
        final JDBCRepositorySQL[] result = new JDBCRepositorySQL[1];
        Files.walkFileTree(Paths.get(url.toURI()), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) throws IOException {
                if (file.toString().endsWith(JDBCRepositorySQLLoader.FILE_EXTENSION)) {
                    JDBCRepositorySQL provider = (JDBCRepositorySQL)JAXBContext.newInstance((Class[])new Class[]{JDBCRepositorySQL.class}).createUnmarshaller().unmarshal(Files.newInputStream(file.toFile().toPath(), new OpenOption[0]));
                    if (provider.isDefault()) {
                        result[0] = provider;
                    }
                    if (Objects.equals(provider.getType(), type)) {
                        result[0] = provider;
                        return FileVisitResult.TERMINATE;
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return result[0];
    }

    private static JDBCRepositorySQL loadFromJar(URL url, String type) throws JAXBException, IOException {
        JDBCRepositorySQL defaultProvider = null;
        try (JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();){
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                String name = entries.nextElement().getName();
                if (!name.startsWith(ROOT_DIRECTORY) || !name.endsWith(FILE_EXTENSION)) continue;
                InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(name);
                JDBCRepositorySQL provider = (JDBCRepositorySQL)JAXBContext.newInstance((Class[])new Class[]{JDBCRepositorySQL.class}).createUnmarshaller().unmarshal(inputStream);
                if (provider.isDefault()) {
                    defaultProvider = provider;
                }
                if (!Objects.equals(provider.getType(), type)) continue;
                JDBCRepositorySQL jDBCRepositorySQL = provider;
                return jDBCRepositorySQL;
            }
        }
        return defaultProvider;
    }

    @Generated
    private JDBCRepositorySQLLoader() {
    }
}

