/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.sql92.visitor.statement.impl;

import java.util.Collections;
import java.util.Properties;
import lombok.Generated;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.sql.parser.api.visitor.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.operation.SQLStatementVisitor;
import org.apache.shardingsphere.sql.parser.api.visitor.type.DDLSQLVisitor;
import org.apache.shardingsphere.sql.parser.autogen.SQL92StatementParser;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.AlterDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.CreateDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.column.ColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.column.alter.AddColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.column.alter.DropColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.column.alter.ModifyColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.constraint.ConstraintDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.constraint.ConstraintSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.constraint.alter.AddConstraintDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.constraint.alter.DropConstraintDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.DataTypeSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.value.collection.CollectionValue;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.sql92.ddl.SQL92AlterTableStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.sql92.ddl.SQL92CreateTableStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.sql92.ddl.SQL92DropTableStatement;
import org.apache.shardingsphere.sql.parser.sql92.visitor.statement.impl.SQL92StatementSQLVisitor;

public final class SQL92DDLStatementSQLVisitor
extends SQL92StatementSQLVisitor
implements DDLSQLVisitor,
SQLStatementVisitor {
    public SQL92DDLStatementSQLVisitor(Properties props) {
        super(props);
    }

    @Override
    public ASTNode visitCreateTable(SQL92StatementParser.CreateTableContext ctx) {
        SQL92CreateTableStatement result = new SQL92CreateTableStatement();
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        if (null != ctx.createDefinitionClause()) {
            CollectionValue createDefinitions = (CollectionValue)this.visit((ParseTree)ctx.createDefinitionClause());
            for (CreateDefinitionSegment each : createDefinitions.getValue()) {
                if (each instanceof ColumnDefinitionSegment) {
                    result.getColumnDefinitions().add((ColumnDefinitionSegment)each);
                    continue;
                }
                if (!(each instanceof ConstraintDefinitionSegment)) continue;
                result.getConstraintDefinitions().add((ConstraintDefinitionSegment)each);
            }
        }
        return result;
    }

    @Override
    public ASTNode visitCreateDefinitionClause(SQL92StatementParser.CreateDefinitionClauseContext ctx) {
        CollectionValue result = new CollectionValue();
        for (SQL92StatementParser.CreateDefinitionContext each : ctx.createDefinition()) {
            if (null != each.columnDefinition()) {
                result.getValue().add((ColumnDefinitionSegment)this.visit((ParseTree)each.columnDefinition()));
            }
            if (null != each.constraintDefinition()) {
                result.getValue().add((ConstraintDefinitionSegment)this.visit((ParseTree)each.constraintDefinition()));
            }
            if (null == each.checkConstraintDefinition()) continue;
            result.getValue().add((ConstraintDefinitionSegment)this.visit((ParseTree)each.checkConstraintDefinition()));
        }
        return result;
    }

    @Override
    public ASTNode visitColumnDefinition(SQL92StatementParser.ColumnDefinitionContext ctx) {
        ColumnSegment column = (ColumnSegment)this.visit((ParseTree)ctx.columnName());
        DataTypeSegment dataType = (DataTypeSegment)this.visit((ParseTree)ctx.dataType());
        boolean isPrimaryKey = ctx.dataTypeOption().stream().anyMatch(each -> null != each.primaryKey());
        ColumnDefinitionSegment result = new ColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), column, dataType, isPrimaryKey, false);
        for (SQL92StatementParser.DataTypeOptionContext each2 : ctx.dataTypeOption()) {
            if (null == each2.referenceDefinition()) continue;
            result.getReferencedTables().add((SimpleTableSegment)this.visit((ParseTree)each2.referenceDefinition().tableName()));
        }
        return result;
    }

    @Override
    public ASTNode visitCheckConstraintDefinition(SQL92StatementParser.CheckConstraintDefinitionContext ctx) {
        return new ConstraintDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
    }

    @Override
    public ASTNode visitAddConstraintSpecification(SQL92StatementParser.AddConstraintSpecificationContext ctx) {
        return new AddConstraintDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (ConstraintDefinitionSegment)this.visit((ParseTree)ctx.constraintDefinition()));
    }

    @Override
    public ASTNode visitDropConstraintSpecification(SQL92StatementParser.DropConstraintSpecificationContext ctx) {
        return new DropConstraintDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (ConstraintSegment)this.visit((ParseTree)ctx.constraintDefinition().constraintName()));
    }

    @Override
    public ASTNode visitConstraintDefinition(SQL92StatementParser.ConstraintDefinitionContext ctx) {
        ConstraintDefinitionSegment result = new ConstraintDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
        if (null != ctx.constraintName()) {
            result.setConstraintName((ConstraintSegment)this.visit((ParseTree)ctx.constraintName()));
        }
        if (null != ctx.primaryKeyOption()) {
            result.getPrimaryKeyColumns().addAll(((CollectionValue)this.visit((ParseTree)ctx.primaryKeyOption().columnNames())).getValue());
        }
        if (null != ctx.foreignKeyOption()) {
            result.setReferencedTable((SimpleTableSegment)this.visit((ParseTree)ctx.foreignKeyOption().referenceDefinition().tableName()));
        }
        return result;
    }

    @Override
    public ASTNode visitConstraintName(SQL92StatementParser.ConstraintNameContext ctx) {
        return new ConstraintSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.identifier()));
    }

    @Override
    public ASTNode visitAlterTable(SQL92StatementParser.AlterTableContext ctx) {
        SQL92AlterTableStatement result = new SQL92AlterTableStatement();
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        if (null != ctx.alterDefinitionClause()) {
            for (AlterDefinitionSegment each : ((CollectionValue)this.visit((ParseTree)ctx.alterDefinitionClause())).getValue()) {
                if (each instanceof AddColumnDefinitionSegment) {
                    result.getAddColumnDefinitions().add((AddColumnDefinitionSegment)each);
                    continue;
                }
                if (each instanceof ModifyColumnDefinitionSegment) {
                    result.getModifyColumnDefinitions().add((ModifyColumnDefinitionSegment)each);
                    continue;
                }
                if (each instanceof DropColumnDefinitionSegment) {
                    result.getDropColumnDefinitions().add((DropColumnDefinitionSegment)each);
                    continue;
                }
                if (each instanceof AddConstraintDefinitionSegment) {
                    result.getAddConstraintDefinitions().add((AddConstraintDefinitionSegment)each);
                    continue;
                }
                if (!(each instanceof DropConstraintDefinitionSegment)) continue;
                result.getDropConstraintDefinitions().add((DropConstraintDefinitionSegment)each);
            }
        }
        return result;
    }

    @Override
    public ASTNode visitAlterDefinitionClause(SQL92StatementParser.AlterDefinitionClauseContext ctx) {
        CollectionValue result = new CollectionValue();
        if (null != ctx.addColumnSpecification()) {
            result.getValue().addAll(((CollectionValue)this.visit((ParseTree)ctx.addColumnSpecification())).getValue());
        }
        if (null != ctx.modifyColumnSpecification()) {
            result.getValue().add((ModifyColumnDefinitionSegment)this.visit((ParseTree)ctx.modifyColumnSpecification()));
        }
        if (null != ctx.dropColumnSpecification()) {
            result.getValue().add((DropColumnDefinitionSegment)this.visit((ParseTree)ctx.dropColumnSpecification()));
        }
        return result;
    }

    @Override
    public ASTNode visitAddColumnSpecification(SQL92StatementParser.AddColumnSpecificationContext ctx) {
        CollectionValue result = new CollectionValue();
        AddColumnDefinitionSegment addColumnDefinition = new AddColumnDefinitionSegment(ctx.columnDefinition().getStart().getStartIndex(), ctx.columnDefinition().getStop().getStopIndex(), Collections.singletonList((ColumnDefinitionSegment)this.visit((ParseTree)ctx.columnDefinition())));
        result.getValue().add(addColumnDefinition);
        return result;
    }

    @Override
    public ASTNode visitModifyColumnSpecification(SQL92StatementParser.ModifyColumnSpecificationContext ctx) {
        return new ModifyColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (ColumnDefinitionSegment)this.visit((ParseTree)ctx.columnDefinition()));
    }

    @Override
    public ASTNode visitDropColumnSpecification(SQL92StatementParser.DropColumnSpecificationContext ctx) {
        return new DropColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), Collections.singletonList((ColumnSegment)this.visit((ParseTree)ctx.columnName())));
    }

    @Override
    public ASTNode visitDropTable(SQL92StatementParser.DropTableContext ctx) {
        SQL92DropTableStatement result = new SQL92DropTableStatement();
        result.getTables().addAll(((CollectionValue)this.visit((ParseTree)ctx.tableNames())).getValue());
        return result;
    }

    @Generated
    public SQL92DDLStatementSQLVisitor() {
    }
}

