/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.mysql.visitor.impl;

import java.util.Optional;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.statement.DCLVisitor;
import org.apache.shardingsphere.sql.parser.autogen.MySQLStatementParser;
import org.apache.shardingsphere.sql.parser.mysql.visitor.MySQLVisitor;
import org.apache.shardingsphere.sql.parser.sql.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.statement.dcl.AlterUserStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.dcl.CreateRoleStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.dcl.CreateUserStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.dcl.DropRoleStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.dcl.DropUserStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.dcl.GrantStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.dcl.RenameUserStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.dcl.RevokeStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.dcl.SetDefaultRoleStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.dcl.SetPasswordStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.dcl.SetRoleStatement;

public final class MySQLDCLVisitor
extends MySQLVisitor
implements DCLVisitor {
    @Override
    public ASTNode visitGrant(MySQLStatementParser.GrantContext ctx) {
        GrantStatement result = new GrantStatement();
        Optional<SimpleTableSegment> tableSegmentOptional = null == ctx.privilegeClause() ? Optional.empty() : this.getTableFromPrivilegeClause(ctx.privilegeClause());
        tableSegmentOptional.ifPresent(tableSegment -> result.getTables().add(tableSegment));
        return result;
    }

    @Override
    public ASTNode visitRevoke(MySQLStatementParser.RevokeContext ctx) {
        RevokeStatement result = new RevokeStatement();
        Optional<SimpleTableSegment> tableSegmentOptional = null == ctx.privilegeClause() ? Optional.empty() : this.getTableFromPrivilegeClause(ctx.privilegeClause());
        tableSegmentOptional.ifPresent(tableSegment -> result.getTables().add(tableSegment));
        return result;
    }

    private Optional<SimpleTableSegment> getTableFromPrivilegeClause(MySQLStatementParser.PrivilegeClauseContext ctx) {
        MySQLStatementParser.TableNameContext tableName;
        if (null != ctx.onObjectClause() && null != (tableName = ctx.onObjectClause().privilegeLevel().tableName())) {
            return Optional.of((SimpleTableSegment)this.visitTableName(tableName));
        }
        return Optional.empty();
    }

    @Override
    public ASTNode visitCreateUser(MySQLStatementParser.CreateUserContext ctx) {
        return new CreateUserStatement();
    }

    @Override
    public ASTNode visitDropUser(MySQLStatementParser.DropUserContext ctx) {
        return new DropUserStatement();
    }

    @Override
    public ASTNode visitAlterUser(MySQLStatementParser.AlterUserContext ctx) {
        return new AlterUserStatement();
    }

    @Override
    public ASTNode visitRenameUser(MySQLStatementParser.RenameUserContext ctx) {
        return new RenameUserStatement();
    }

    @Override
    public ASTNode visitCreateRole(MySQLStatementParser.CreateRoleContext ctx) {
        return new CreateRoleStatement();
    }

    @Override
    public ASTNode visitDropRole(MySQLStatementParser.DropRoleContext ctx) {
        return new DropRoleStatement();
    }

    @Override
    public ASTNode visitSetDefaultRole(MySQLStatementParser.SetDefaultRoleContext ctx) {
        return new SetDefaultRoleStatement();
    }

    @Override
    public ASTNode visitSetRole(MySQLStatementParser.SetRoleContext ctx) {
        return new SetRoleStatement();
    }

    @Override
    public ASTNode visitSetPassword(MySQLStatementParser.SetPasswordContext ctx) {
        return new SetPasswordStatement();
    }
}

