/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.sql.process;

import java.util.Collections;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupContext;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupReportContext;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.SQLExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.process.Process;
import org.apache.shardingsphere.infra.executor.sql.process.ProcessIdContext;
import org.apache.shardingsphere.infra.executor.sql.process.ProcessRegistry;
import org.apache.shardingsphere.infra.metadata.user.Grantee;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.DDLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.DMLStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.MySQLStatement;

public final class ProcessEngine {
    public String connect(Grantee grantee, String databaseName) {
        ExecutionGroupContext executionGroupContext = new ExecutionGroupContext(Collections.emptyList(), new ExecutionGroupReportContext(databaseName, grantee));
        Process process = new Process(executionGroupContext, true);
        ProcessRegistry.getInstance().add(process);
        return executionGroupContext.getReportContext().getProcessId();
    }

    public void disconnect(String processId) {
        ProcessRegistry.getInstance().remove(processId);
    }

    public void executeSQL(ExecutionGroupContext<? extends SQLExecutionUnit> executionGroupContext, QueryContext queryContext) {
        if (this.isMySQLDDLOrDMLStatement(queryContext.getSqlStatementContext().getSqlStatement())) {
            String processId = executionGroupContext.getReportContext().getProcessId();
            boolean heldByConnection = null != ProcessRegistry.getInstance().get(processId) && ProcessRegistry.getInstance().get(processId).isHeldByConnection();
            ProcessIdContext.set(processId);
            ProcessRegistry.getInstance().add(new Process(queryContext.getSql(), executionGroupContext, heldByConnection));
        }
    }

    public void completeSQLUnitExecution() {
        if (ProcessIdContext.isEmpty()) {
            return;
        }
        ProcessRegistry.getInstance().get(ProcessIdContext.get()).completeExecutionUnit();
    }

    public void completeSQLExecution() {
        if (ProcessIdContext.isEmpty()) {
            return;
        }
        Process process = ProcessRegistry.getInstance().get(ProcessIdContext.get());
        if (null == process) {
            return;
        }
        ExecutionGroupContext executionGroupContext = new ExecutionGroupContext(Collections.emptyList(), new ExecutionGroupReportContext(ProcessIdContext.get(), process.getDatabaseName(), new Grantee(process.getUsername(), process.getHostname())));
        if (process.isHeldByConnection()) {
            ProcessRegistry.getInstance().add(new Process(executionGroupContext, true));
        } else {
            ProcessRegistry.getInstance().remove(ProcessIdContext.get());
        }
        ProcessIdContext.remove();
    }

    private boolean isMySQLDDLOrDMLStatement(SQLStatement sqlStatement) {
        return sqlStatement instanceof MySQLStatement && (sqlStatement instanceof DDLStatement || sqlStatement instanceof DMLStatement);
    }
}

