/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.sql.execute.engine.raw;

import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.infra.executor.kernel.ExecutorEngine;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupContext;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.SQLExecutorExceptionHandler;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.raw.RawSQLExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.raw.callback.RawSQLExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.result.ExecuteResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.update.UpdateResult;
import org.apache.shardingsphere.infra.executor.sql.process.ProcessEngine;
import org.apache.shardingsphere.infra.session.connection.ConnectionContext;
import org.apache.shardingsphere.infra.session.query.QueryContext;

public final class RawExecutor {
    private final ExecutorEngine executorEngine;
    private final ConnectionContext connectionContext;
    private final ProcessEngine processEngine = new ProcessEngine();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ExecuteResult> execute(ExecutionGroupContext<RawSQLExecutionUnit> executionGroupContext, QueryContext queryContext, RawSQLExecutorCallback callback) throws SQLException {
        try {
            this.processEngine.executeSQL(executionGroupContext, queryContext);
            List results = this.execute(executionGroupContext, (RawSQLExecutorCallback)null, callback);
            List<ExecuteResult> list = results.isEmpty() || null == results.get(0) ? Collections.singletonList(new UpdateResult(0, 0L)) : results;
            return list;
        }
        finally {
            this.processEngine.completeSQLExecution();
        }
    }

    private <T> List<T> execute(ExecutionGroupContext<RawSQLExecutionUnit> executionGroupContext, RawSQLExecutorCallback firstCallback, RawSQLExecutorCallback callback) throws SQLException {
        try {
            return this.executorEngine.execute(executionGroupContext, firstCallback, callback, this.connectionContext.getTransactionContext().isInTransaction());
        }
        catch (SQLException ex) {
            SQLExecutorExceptionHandler.handleException(ex);
            return Collections.emptyList();
        }
    }

    @Generated
    public RawExecutor(ExecutorEngine executorEngine, ConnectionContext connectionContext) {
        this.executorEngine = executorEngine;
        this.connectionContext = connectionContext;
    }
}

