/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.connection.validator;

import java.util.Collection;
import java.util.HashSet;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.exception.dialect.exception.syntax.table.NoSuchTableException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;

public final class ShardingSphereMetaDataValidateUtils {
    private static final Collection<String> EXCLUDE_VALIDATE_TABLES = new HashSet<String>(1, 1.0f);

    public static void validateTableExist(SQLStatementContext sqlStatementContext, ShardingSphereDatabase database) {
        String defaultSchemaName = new DatabaseTypeRegistry(sqlStatementContext.getDatabaseType()).getDefaultSchemaName(database.getName());
        ShardingSphereSchema schema = sqlStatementContext.getTablesContext().getSchemaName().map(arg_0 -> ((ShardingSphereDatabase)database).getSchema(arg_0)).orElseGet(() -> database.getSchema(defaultSchemaName));
        for (String each : sqlStatementContext.getTablesContext().getTableNames()) {
            if (EXCLUDE_VALIDATE_TABLES.contains(each.toUpperCase()) || schema.containsTable(each)) continue;
            throw new NoSuchTableException(each);
        }
    }

    @Generated
    private ShardingSphereMetaDataValidateUtils() {
    }

    static {
        EXCLUDE_VALIDATE_TABLES.add("DUAL");
    }
}

