/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.context.refresher.type;

import java.util.Collection;
import java.util.Optional;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.context.refresher.MetaDataRefresher;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.event.AddSchemaEvent;
import org.apache.shardingsphere.infra.metadata.database.schema.event.MetaDataRefreshedEvent;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.CreateSchemaStatement;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.ddl.CreateSchemaStatementHandler;

public final class CreateSchemaStatementSchemaRefresher
implements MetaDataRefresher<CreateSchemaStatement> {
    @Override
    public Optional<MetaDataRefreshedEvent> refresh(ShardingSphereDatabase database, Collection<String> logicDataSourceNames, String schemaName, CreateSchemaStatement sqlStatement, ConfigurationProperties props) {
        Optional schema;
        Optional optional = schema = sqlStatement.getSchemaName().isPresent() ? sqlStatement.getSchemaName() : CreateSchemaStatementHandler.getUsername((CreateSchemaStatement)sqlStatement);
        if (!schema.isPresent()) {
            return Optional.empty();
        }
        String actualSchemaName = ((IdentifierValue)schema.get()).getValue().toLowerCase();
        database.putSchema(actualSchemaName, new ShardingSphereSchema());
        AddSchemaEvent event = new AddSchemaEvent(database.getName(), actualSchemaName);
        return Optional.of(event);
    }

    public String getType() {
        return CreateSchemaStatement.class.getName();
    }
}

