/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.segment.from.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.segment.from.SimpleTableSegmentBinderContext;
import org.apache.shardingsphere.infra.binder.segment.from.TableSegmentBinderContext;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementBinderContext;
import org.apache.shardingsphere.infra.database.core.metadata.database.DialectDatabaseMetaData;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.database.opengauss.type.OpenGaussDatabaseType;
import org.apache.shardingsphere.infra.database.postgresql.type.PostgreSQLDatabaseType;
import org.apache.shardingsphere.infra.exception.TableNotExistsException;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.metadata.database.schema.builder.SystemSchemaBuilderRule;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereColumn;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ColumnProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.bounded.ColumnSegmentBoundedInfo;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.bounded.TableSegmentBoundedInfo;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableNameSegment;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class SimpleTableSegmentBinder {
    private static final Collection<String> SYSTEM_CATALOG_TABLES = new HashSet<String>(4, 1.0f);
    private static final String PG_CATALOG = "pg_catalog";

    public static SimpleTableSegment bind(SimpleTableSegment segment, SQLStatementBinderContext statementBinderContext, Map<String, TableSegmentBinderContext> tableBinderContexts) {
        SimpleTableSegmentBinder.fillPivotColumnNamesInBinderContext(segment, statementBinderContext);
        IdentifierValue originalDatabase = SimpleTableSegmentBinder.getDatabaseName(segment, statementBinderContext);
        IdentifierValue originalSchema = SimpleTableSegmentBinder.getSchemaName(segment, statementBinderContext);
        SimpleTableSegmentBinder.checkTableExists(segment.getTableName().getIdentifier().getValue(), statementBinderContext, originalDatabase.getValue(), originalSchema.getValue());
        ShardingSphereSchema schema = statementBinderContext.getMetaData().getDatabase(originalDatabase.getValue()).getSchema(originalSchema.getValue());
        tableBinderContexts.put(segment.getAliasName().orElseGet(() -> segment.getTableName().getIdentifier().getValue()).toLowerCase(), SimpleTableSegmentBinder.createSimpleTableBinderContext(segment, schema, originalDatabase, originalSchema, statementBinderContext));
        TableNameSegment tableNameSegment = new TableNameSegment(segment.getTableName().getStartIndex(), segment.getTableName().getStopIndex(), segment.getTableName().getIdentifier());
        tableNameSegment.setTableBoundedInfo(new TableSegmentBoundedInfo(originalDatabase, originalSchema));
        SimpleTableSegment result = new SimpleTableSegment(tableNameSegment);
        segment.getOwner().ifPresent(arg_0 -> ((SimpleTableSegment)result).setOwner(arg_0));
        segment.getAliasSegment().ifPresent(arg_0 -> ((SimpleTableSegment)result).setAlias(arg_0));
        return result;
    }

    private static void fillPivotColumnNamesInBinderContext(SimpleTableSegment segment, SQLStatementBinderContext statementBinderContext) {
        segment.getPivot().ifPresent(optional -> optional.getPivotColumns().forEach(each -> statementBinderContext.getPivotColumnNames().add(each.getIdentifier().getValue().toLowerCase())));
    }

    private static IdentifierValue getDatabaseName(SimpleTableSegment tableSegment, SQLStatementBinderContext statementBinderContext) {
        DialectDatabaseMetaData dialectDatabaseMetaData = new DatabaseTypeRegistry(statementBinderContext.getDatabaseType()).getDialectDatabaseMetaData();
        Optional<String> owner = dialectDatabaseMetaData.getDefaultSchema().isPresent() ? tableSegment.getOwner().flatMap(OwnerSegment::getOwner) : tableSegment.getOwner();
        return new IdentifierValue(owner.map(optional -> optional.getIdentifier().getValue()).orElse(statementBinderContext.getDefaultDatabaseName()));
    }

    private static IdentifierValue getSchemaName(SimpleTableSegment segment, SQLStatementBinderContext statementBinderContext) {
        if (segment.getOwner().isPresent()) {
            return ((OwnerSegment)segment.getOwner().get()).getIdentifier();
        }
        DatabaseType databaseType = statementBinderContext.getDatabaseType();
        if ((databaseType instanceof PostgreSQLDatabaseType || databaseType instanceof OpenGaussDatabaseType) && SYSTEM_CATALOG_TABLES.contains(segment.getTableName().getIdentifier().getValue().toLowerCase())) {
            return new IdentifierValue(PG_CATALOG);
        }
        return new IdentifierValue(new DatabaseTypeRegistry(databaseType).getDefaultSchemaName(statementBinderContext.getDefaultDatabaseName()));
    }

    private static SimpleTableSegmentBinderContext createSimpleTableBinderContext(SimpleTableSegment segment, ShardingSphereSchema schema, IdentifierValue originalDatabase, IdentifierValue originalSchema, SQLStatementBinderContext statementBinderContext) {
        Collection columnNames = Optional.ofNullable(schema.getTable(segment.getTableName().getIdentifier().getValue())).map(ShardingSphereTable::getColumnValues).orElseGet(Collections::emptyList);
        LinkedList<ProjectionSegment> projectionSegments = new LinkedList<ProjectionSegment>();
        DialectDatabaseMetaData dialectDatabaseMetaData = new DatabaseTypeRegistry(statementBinderContext.getDatabaseType()).getDialectDatabaseMetaData();
        for (ShardingSphereColumn each : columnNames) {
            ColumnSegment columnSegment = new ColumnSegment(0, 0, new IdentifierValue(each.getName(), dialectDatabaseMetaData.getQuoteCharacter()));
            columnSegment.setOwner(new OwnerSegment(0, 0, segment.getAlias().orElse(segment.getTableName().getIdentifier())));
            columnSegment.setColumnBoundedInfo(new ColumnSegmentBoundedInfo(originalDatabase, originalSchema, segment.getTableName().getIdentifier(), new IdentifierValue(each.getName(), dialectDatabaseMetaData.getQuoteCharacter())));
            ColumnProjectionSegment columnProjectionSegment = new ColumnProjectionSegment(columnSegment);
            columnProjectionSegment.setVisible(each.isVisible());
            projectionSegments.add((ProjectionSegment)columnProjectionSegment);
        }
        return new SimpleTableSegmentBinderContext(projectionSegments);
    }

    private static void checkTableExists(String tableName, SQLStatementBinderContext statementBinderContext, String databaseName, String schemaName) {
        if ("dual".equalsIgnoreCase(tableName)) {
            return;
        }
        if (SystemSchemaBuilderRule.isSystemTable((String)schemaName, (String)tableName)) {
            return;
        }
        ShardingSpherePreconditions.checkState((statementBinderContext.getMetaData().containsDatabase(databaseName) && statementBinderContext.getMetaData().getDatabase(databaseName).containsSchema(schemaName) && statementBinderContext.getMetaData().getDatabase(databaseName).getSchema(schemaName).containsTable(tableName) ? 1 : 0) != 0, () -> new TableNotExistsException(tableName));
    }

    @Generated
    private SimpleTableSegmentBinder() {
    }

    static {
        SYSTEM_CATALOG_TABLES.add("pg_database");
        SYSTEM_CATALOG_TABLES.add("pg_tables");
        SYSTEM_CATALOG_TABLES.add("pg_roles");
        SYSTEM_CATALOG_TABLES.add("pg_settings");
    }
}

