/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.context.segment.select.projection.engine;

import java.util.LinkedHashSet;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.DerivedColumn;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.AggregationDistinctProjection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.AggregationProjection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.ExpressionProjection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.ParameterMarkerProjection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.ShorthandProjection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.SubqueryProjection;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.sql.parser.sql.common.enums.AggregationType;
import org.apache.shardingsphere.sql.parser.sql.common.enums.Paren;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.AggregationDistinctProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.AggregationProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ColumnProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ExpressionProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ShorthandProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.SubqueryProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class ProjectionEngine {
    private final DatabaseType databaseType;
    private int aggregationAverageDerivedColumnCount;
    private int aggregationDistinctDerivedColumnCount;

    public Optional<Projection> createProjection(TableSegment table, ProjectionSegment projectionSegment) {
        if (projectionSegment instanceof ShorthandProjectionSegment) {
            return Optional.of(this.createProjection(table, (ShorthandProjectionSegment)projectionSegment));
        }
        if (projectionSegment instanceof ColumnProjectionSegment) {
            return Optional.of(this.createProjection((ColumnProjectionSegment)projectionSegment));
        }
        if (projectionSegment instanceof ExpressionProjectionSegment) {
            return Optional.of(this.createProjection((ExpressionProjectionSegment)projectionSegment));
        }
        if (projectionSegment instanceof AggregationDistinctProjectionSegment) {
            return Optional.of(this.createProjection((AggregationDistinctProjectionSegment)projectionSegment));
        }
        if (projectionSegment instanceof AggregationProjectionSegment) {
            return Optional.of(this.createProjection((AggregationProjectionSegment)projectionSegment));
        }
        if (projectionSegment instanceof SubqueryProjectionSegment) {
            return Optional.of(this.createProjection(table, (SubqueryProjectionSegment)projectionSegment));
        }
        if (projectionSegment instanceof ParameterMarkerExpressionSegment) {
            return Optional.of(this.createProjection((ParameterMarkerExpressionSegment)projectionSegment));
        }
        return Optional.empty();
    }

    private ParameterMarkerProjection createProjection(ParameterMarkerExpressionSegment projectionSegment) {
        return new ParameterMarkerProjection(projectionSegment.getParameterMarkerIndex(), projectionSegment.getParameterMarkerType(), projectionSegment.getAlias().orElse(null));
    }

    private SubqueryProjection createProjection(TableSegment table, SubqueryProjectionSegment projectionSegment) {
        Projection subqueryProjection = this.createProjection(table, (ProjectionSegment)projectionSegment.getSubquery().getSelect().getProjections().getProjections().iterator().next()).orElseThrow(() -> new IllegalArgumentException("Subquery projection must have at least one projection column."));
        return new SubqueryProjection(projectionSegment, subqueryProjection, projectionSegment.getAlias().orElse(null), this.databaseType);
    }

    private ShorthandProjection createProjection(TableSegment table, ShorthandProjectionSegment projectionSegment) {
        IdentifierValue owner = projectionSegment.getOwner().map(OwnerSegment::getIdentifier).orElse(null);
        LinkedHashSet<Projection> projections = new LinkedHashSet<Projection>();
        projectionSegment.getActualProjectionSegments().forEach(each -> this.createProjection(table, (ProjectionSegment)each).ifPresent(projections::add));
        return new ShorthandProjection(owner, projections);
    }

    private ColumnProjection createProjection(ColumnProjectionSegment projectionSegment) {
        IdentifierValue owner = projectionSegment.getColumn().getOwner().isPresent() ? ((OwnerSegment)projectionSegment.getColumn().getOwner().get()).getIdentifier() : null;
        IdentifierValue alias = projectionSegment.getAliasName().isPresent() ? (IdentifierValue)projectionSegment.getAlias().orElse(null) : null;
        ColumnProjection result = new ColumnProjection(owner, projectionSegment.getColumn().getIdentifier(), alias, this.databaseType);
        result.setOriginalColumn(projectionSegment.getColumn().getColumnBoundedInfo().getOriginalColumn());
        result.setOriginalTable(projectionSegment.getColumn().getColumnBoundedInfo().getOriginalTable());
        return result;
    }

    private ExpressionProjection createProjection(ExpressionProjectionSegment projectionSegment) {
        return new ExpressionProjection(projectionSegment, projectionSegment.getAlias().orElse(null), this.databaseType);
    }

    private AggregationDistinctProjection createProjection(AggregationDistinctProjectionSegment projectionSegment) {
        IdentifierValue alias = projectionSegment.getAlias().orElseGet(() -> new IdentifierValue(DerivedColumn.AGGREGATION_DISTINCT_DERIVED.getDerivedColumnAlias(this.aggregationDistinctDerivedColumnCount++)));
        AggregationDistinctProjection result = new AggregationDistinctProjection(projectionSegment.getStartIndex(), projectionSegment.getStopIndex(), projectionSegment.getType(), projectionSegment.getExpression(), alias, projectionSegment.getDistinctInnerExpression(), this.databaseType);
        if (AggregationType.AVG == result.getType()) {
            this.appendAverageDistinctDerivedProjection(result);
        }
        return result;
    }

    private AggregationProjection createProjection(AggregationProjectionSegment projectionSegment) {
        AggregationProjection result = new AggregationProjection(projectionSegment.getType(), projectionSegment.getExpression(), projectionSegment.getAlias().orElse(null), this.databaseType);
        if (AggregationType.AVG == result.getType()) {
            this.appendAverageDerivedProjection(result);
        }
        return result;
    }

    private void appendAverageDistinctDerivedProjection(AggregationDistinctProjection averageDistinctProjection) {
        String distinctInnerExpression = averageDistinctProjection.getDistinctInnerExpression();
        String countAlias = DerivedColumn.AVG_COUNT_ALIAS.getDerivedColumnAlias(this.aggregationAverageDerivedColumnCount);
        String innerExpression = averageDistinctProjection.getExpression().substring(averageDistinctProjection.getExpression().indexOf(Paren.PARENTHESES.getLeftParen()));
        AggregationDistinctProjection countDistinctProjection = new AggregationDistinctProjection(0, 0, AggregationType.COUNT, AggregationType.COUNT.name() + innerExpression, new IdentifierValue(countAlias), distinctInnerExpression, this.databaseType);
        String sumAlias = DerivedColumn.AVG_SUM_ALIAS.getDerivedColumnAlias(this.aggregationAverageDerivedColumnCount);
        AggregationDistinctProjection sumDistinctProjection = new AggregationDistinctProjection(0, 0, AggregationType.SUM, AggregationType.SUM.name() + innerExpression, new IdentifierValue(sumAlias), distinctInnerExpression, this.databaseType);
        averageDistinctProjection.getDerivedAggregationProjections().add(countDistinctProjection);
        averageDistinctProjection.getDerivedAggregationProjections().add(sumDistinctProjection);
        ++this.aggregationAverageDerivedColumnCount;
    }

    private void appendAverageDerivedProjection(AggregationProjection averageProjection) {
        String countAlias = DerivedColumn.AVG_COUNT_ALIAS.getDerivedColumnAlias(this.aggregationAverageDerivedColumnCount);
        String innerExpression = averageProjection.getExpression().substring(averageProjection.getExpression().indexOf(Paren.PARENTHESES.getLeftParen()));
        AggregationProjection countProjection = new AggregationProjection(AggregationType.COUNT, AggregationType.COUNT.name() + innerExpression, new IdentifierValue(countAlias), this.databaseType);
        String sumAlias = DerivedColumn.AVG_SUM_ALIAS.getDerivedColumnAlias(this.aggregationAverageDerivedColumnCount);
        AggregationProjection sumProjection = new AggregationProjection(AggregationType.SUM, AggregationType.SUM.name() + innerExpression, new IdentifierValue(sumAlias), this.databaseType);
        averageProjection.getDerivedAggregationProjections().add(countProjection);
        averageProjection.getDerivedAggregationProjections().add(sumProjection);
        ++this.aggregationAverageDerivedColumnCount;
    }

    @Generated
    public ProjectionEngine(DatabaseType databaseType) {
        this.databaseType = databaseType;
    }
}

