/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.context.segment.insert.keygen.engine;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.segment.insert.keygen.GeneratedKeyContext;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereColumn;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.InsertValuesSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.SetAssignmentSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.subquery.SubquerySegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.InsertStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.dml.InsertStatementHandler;

public final class GeneratedKeyContextEngine {
    private final InsertStatement insertStatement;
    private final ShardingSphereSchema schema;

    public Optional<GeneratedKeyContext> createGenerateKeyContext(List<String> insertColumnNames, List<List<ExpressionSegment>> valueExpressions, List<Object> params) {
        String tableName = Optional.ofNullable(this.insertStatement.getTable()).map(optional -> optional.getTableName().getIdentifier().getValue()).orElse("");
        return this.findGenerateKeyColumn(tableName).map(optional -> this.containsGenerateKey(insertColumnNames, (String)optional) ? this.findGeneratedKey(insertColumnNames, valueExpressions, params, (String)optional) : new GeneratedKeyContext((String)optional, true));
    }

    private Optional<String> findGenerateKeyColumn(String tableName) {
        if (!this.schema.containsTable(tableName)) {
            return Optional.empty();
        }
        for (ShardingSphereColumn each : this.schema.getTable(tableName).getColumnValues()) {
            if (!each.isGenerated()) continue;
            return Optional.of(each.getName());
        }
        return Optional.empty();
    }

    private boolean containsGenerateKey(List<String> insertColumnNames, String generateKeyColumnName) {
        return insertColumnNames.isEmpty() ? this.schema.getVisibleColumnNames(this.insertStatement.getTable().getTableName().getIdentifier().getValue()).size() == this.getValueCountForPerGroup() : insertColumnNames.contains(generateKeyColumnName);
    }

    private int getValueCountForPerGroup() {
        if (!this.insertStatement.getValues().isEmpty()) {
            return ((InsertValuesSegment)this.insertStatement.getValues().iterator().next()).getValues().size();
        }
        Optional setAssignment = InsertStatementHandler.getSetAssignmentSegment((InsertStatement)this.insertStatement);
        if (setAssignment.isPresent()) {
            return ((SetAssignmentSegment)setAssignment.get()).getAssignments().size();
        }
        if (this.insertStatement.getInsertSelect().isPresent()) {
            return ((SubquerySegment)this.insertStatement.getInsertSelect().get()).getSelect().getProjections().getProjections().size();
        }
        return 0;
    }

    private GeneratedKeyContext findGeneratedKey(List<String> insertColumnNames, List<List<ExpressionSegment>> valueExpressions, List<Object> params, String generateKeyColumnName) {
        GeneratedKeyContext result = new GeneratedKeyContext(generateKeyColumnName, false);
        for (ExpressionSegment each : this.findGenerateKeyExpressions(insertColumnNames, valueExpressions, generateKeyColumnName)) {
            if (each instanceof ParameterMarkerExpressionSegment) {
                if (params.isEmpty() || null == params.get(((ParameterMarkerExpressionSegment)each).getParameterMarkerIndex())) continue;
                result.getGeneratedValues().add((Comparable)params.get(((ParameterMarkerExpressionSegment)each).getParameterMarkerIndex()));
                continue;
            }
            if (!(each instanceof LiteralExpressionSegment)) continue;
            result.getGeneratedValues().add((Comparable)((LiteralExpressionSegment)each).getLiterals());
        }
        return result;
    }

    private Collection<ExpressionSegment> findGenerateKeyExpressions(List<String> insertColumnNames, List<List<ExpressionSegment>> valueExpressions, String generateKeyColumnName) {
        LinkedList<ExpressionSegment> result = new LinkedList<ExpressionSegment>();
        for (List<ExpressionSegment> each : valueExpressions) {
            result.add(each.get(this.findGenerateKeyIndex(insertColumnNames, generateKeyColumnName.toLowerCase())));
        }
        return result;
    }

    private int findGenerateKeyIndex(List<String> insertColumnNames, String generateKeyColumnName) {
        return insertColumnNames.isEmpty() ? this.schema.getVisibleColumnNames(this.insertStatement.getTable().getTableName().getIdentifier().getValue()).indexOf(generateKeyColumnName) : insertColumnNames.indexOf(generateKeyColumnName);
    }

    @Generated
    public GeneratedKeyContextEngine(InsertStatement insertStatement, ShardingSphereSchema schema) {
        this.insertStatement = insertStatement;
        this.schema = schema;
    }
}

