/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.spring.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.MessageQueueSelector;
import org.apache.rocketmq.client.producer.SendCallback;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.TransactionMQProducer;
import org.apache.rocketmq.client.producer.TransactionSendResult;
import org.apache.rocketmq.client.producer.selector.SelectMessageQueueByHash;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.spring.core.RocketMQLocalTransactionListener;
import org.apache.rocketmq.spring.support.RocketMQUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.core.AbstractMessageSendingTemplate;
import org.springframework.messaging.core.MessagePostProcessor;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;
import org.springframework.util.MimeTypeUtils;

public class RocketMQTemplate
extends AbstractMessageSendingTemplate<String>
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(RocketMQTemplate.class);
    private DefaultMQProducer producer;
    private ObjectMapper objectMapper;
    private String charset = "UTF-8";
    private MessageQueueSelector messageQueueSelector = new SelectMessageQueueByHash();
    private final Map<String, TransactionMQProducer> cache = new ConcurrentHashMap<String, TransactionMQProducer>();

    public DefaultMQProducer getProducer() {
        return this.producer;
    }

    public void setProducer(DefaultMQProducer producer) {
        this.producer = producer;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public MessageQueueSelector getMessageQueueSelector() {
        return this.messageQueueSelector;
    }

    public void setMessageQueueSelector(MessageQueueSelector messageQueueSelector) {
        this.messageQueueSelector = messageQueueSelector;
    }

    public SendResult syncSend(String destination, org.springframework.messaging.Message<?> message) {
        return this.syncSend(destination, message, (long)this.producer.getSendMsgTimeout());
    }

    public SendResult syncSend(String destination, org.springframework.messaging.Message<?> message, long timeout) {
        return this.syncSend(destination, message, timeout, 0);
    }

    public SendResult syncSend(String destination, Collection<org.springframework.messaging.Message<?>> messages, long timeout) {
        if (Objects.isNull(messages) || messages.size() == 0) {
            log.error("syncSend with batch failed. destination:{}, messages is empty ", (Object)destination);
            throw new IllegalArgumentException("`messages` can not be empty");
        }
        try {
            long now = System.currentTimeMillis();
            ArrayList<Message> rmqMsgs = new ArrayList<Message>();
            for (org.springframework.messaging.Message<?> msg : messages) {
                if (Objects.isNull(msg) || Objects.isNull(msg.getPayload())) {
                    log.warn("Found a message empty in the batch, skip it");
                    continue;
                }
                Message rocketMsg = RocketMQUtil.convertToRocketMessage(this.objectMapper, this.charset, destination, msg);
                rmqMsgs.add(rocketMsg);
            }
            SendResult sendResult = this.producer.send(rmqMsgs, timeout);
            long costTime = System.currentTimeMillis() - now;
            log.debug("send messages cost: {} ms, msgId:{}", (Object)costTime, (Object)sendResult.getMsgId());
            return sendResult;
        }
        catch (Exception e) {
            log.error("syncSend with batch failed. destination:{}, messages.size:{} ", (Object)destination, (Object)messages.size());
            throw new MessagingException(e.getMessage(), (Throwable)e);
        }
    }

    public SendResult syncSend(String destination, org.springframework.messaging.Message<?> message, long timeout, int delayLevel) {
        if (Objects.isNull(message) || Objects.isNull(message.getPayload())) {
            log.error("syncSend failed. destination:{}, message is null ", (Object)destination);
            throw new IllegalArgumentException("`message` and `message.payload` cannot be null");
        }
        try {
            long now = System.currentTimeMillis();
            Message rocketMsg = RocketMQUtil.convertToRocketMessage(this.objectMapper, this.charset, destination, message);
            if (delayLevel > 0) {
                rocketMsg.setDelayTimeLevel(delayLevel);
            }
            SendResult sendResult = this.producer.send(rocketMsg, timeout);
            long costTime = System.currentTimeMillis() - now;
            log.debug("send message cost: {} ms, msgId:{}", (Object)costTime, (Object)sendResult.getMsgId());
            return sendResult;
        }
        catch (Exception e) {
            log.error("syncSend failed. destination:{}, message:{} ", (Object)destination, message);
            throw new MessagingException(e.getMessage(), (Throwable)e);
        }
    }

    public SendResult syncSend(String destination, Object payload) {
        return this.syncSend(destination, payload, (long)this.producer.getSendMsgTimeout());
    }

    public SendResult syncSend(String destination, Object payload, long timeout) {
        org.springframework.messaging.Message<?> message = this.doConvert(payload, null, null);
        return this.syncSend(destination, message, timeout);
    }

    public SendResult syncSendOrderly(String destination, org.springframework.messaging.Message<?> message, String hashKey) {
        return this.syncSendOrderly(destination, message, hashKey, (long)this.producer.getSendMsgTimeout());
    }

    public SendResult syncSendOrderly(String destination, org.springframework.messaging.Message<?> message, String hashKey, long timeout) {
        if (Objects.isNull(message) || Objects.isNull(message.getPayload())) {
            log.error("syncSendOrderly failed. destination:{}, message is null ", (Object)destination);
            throw new IllegalArgumentException("`message` and `message.payload` cannot be null");
        }
        try {
            long now = System.currentTimeMillis();
            Message rocketMsg = RocketMQUtil.convertToRocketMessage(this.objectMapper, this.charset, destination, message);
            SendResult sendResult = this.producer.send(rocketMsg, this.messageQueueSelector, (Object)hashKey, timeout);
            long costTime = System.currentTimeMillis() - now;
            log.debug("send message cost: {} ms, msgId:{}", (Object)costTime, (Object)sendResult.getMsgId());
            return sendResult;
        }
        catch (Exception e) {
            log.error("syncSendOrderly failed. destination:{}, message:{} ", (Object)destination, message);
            throw new MessagingException(e.getMessage(), (Throwable)e);
        }
    }

    public SendResult syncSendOrderly(String destination, Object payload, String hashKey) {
        return this.syncSendOrderly(destination, payload, hashKey, (long)this.producer.getSendMsgTimeout());
    }

    public SendResult syncSendOrderly(String destination, Object payload, String hashKey, long timeout) {
        org.springframework.messaging.Message<?> message = this.doConvert(payload, null, null);
        return this.syncSendOrderly(destination, message, hashKey, (long)this.producer.getSendMsgTimeout());
    }

    public void asyncSend(String destination, org.springframework.messaging.Message<?> message, SendCallback sendCallback, long timeout, int delayLevel) {
        if (Objects.isNull(message) || Objects.isNull(message.getPayload())) {
            log.error("asyncSend failed. destination:{}, message is null ", (Object)destination);
            throw new IllegalArgumentException("`message` and `message.payload` cannot be null");
        }
        try {
            Message rocketMsg = RocketMQUtil.convertToRocketMessage(this.objectMapper, this.charset, destination, message);
            if (delayLevel > 0) {
                rocketMsg.setDelayTimeLevel(delayLevel);
            }
            this.producer.send(rocketMsg, sendCallback, timeout);
        }
        catch (Exception e) {
            log.info("asyncSend failed. destination:{}, message:{} ", (Object)destination, message);
            throw new MessagingException(e.getMessage(), (Throwable)e);
        }
    }

    public void asyncSend(String destination, org.springframework.messaging.Message<?> message, SendCallback sendCallback, long timeout) {
        this.asyncSend(destination, message, sendCallback, timeout, 0);
    }

    public void asyncSend(String destination, org.springframework.messaging.Message<?> message, SendCallback sendCallback) {
        this.asyncSend(destination, message, sendCallback, (long)this.producer.getSendMsgTimeout());
    }

    public void asyncSend(String destination, Object payload, SendCallback sendCallback, long timeout) {
        org.springframework.messaging.Message<?> message = this.doConvert(payload, null, null);
        this.asyncSend(destination, message, sendCallback, timeout);
    }

    public void asyncSend(String destination, Object payload, SendCallback sendCallback) {
        this.asyncSend(destination, payload, sendCallback, (long)this.producer.getSendMsgTimeout());
    }

    public void asyncSendOrderly(String destination, org.springframework.messaging.Message<?> message, String hashKey, SendCallback sendCallback, long timeout) {
        if (Objects.isNull(message) || Objects.isNull(message.getPayload())) {
            log.error("asyncSendOrderly failed. destination:{}, message is null ", (Object)destination);
            throw new IllegalArgumentException("`message` and `message.payload` cannot be null");
        }
        try {
            Message rocketMsg = RocketMQUtil.convertToRocketMessage(this.objectMapper, this.charset, destination, message);
            this.producer.send(rocketMsg, this.messageQueueSelector, (Object)hashKey, sendCallback, timeout);
        }
        catch (Exception e) {
            log.error("asyncSendOrderly failed. destination:{}, message:{} ", (Object)destination, message);
            throw new MessagingException(e.getMessage(), (Throwable)e);
        }
    }

    public void asyncSendOrderly(String destination, org.springframework.messaging.Message<?> message, String hashKey, SendCallback sendCallback) {
        this.asyncSendOrderly(destination, message, hashKey, sendCallback, (long)this.producer.getSendMsgTimeout());
    }

    public void asyncSendOrderly(String destination, Object payload, String hashKey, SendCallback sendCallback) {
        this.asyncSendOrderly(destination, payload, hashKey, sendCallback, (long)this.producer.getSendMsgTimeout());
    }

    public void asyncSendOrderly(String destination, Object payload, String hashKey, SendCallback sendCallback, long timeout) {
        org.springframework.messaging.Message<?> message = this.doConvert(payload, null, null);
        this.asyncSendOrderly(destination, message, hashKey, sendCallback, timeout);
    }

    public void sendOneWay(String destination, org.springframework.messaging.Message<?> message) {
        if (Objects.isNull(message) || Objects.isNull(message.getPayload())) {
            log.error("sendOneWay failed. destination:{}, message is null ", (Object)destination);
            throw new IllegalArgumentException("`message` and `message.payload` cannot be null");
        }
        try {
            Message rocketMsg = RocketMQUtil.convertToRocketMessage(this.objectMapper, this.charset, destination, message);
            this.producer.sendOneway(rocketMsg);
        }
        catch (Exception e) {
            log.error("sendOneWay failed. destination:{}, message:{} ", (Object)destination, message);
            throw new MessagingException(e.getMessage(), (Throwable)e);
        }
    }

    public void sendOneWay(String destination, Object payload) {
        org.springframework.messaging.Message<?> message = this.doConvert(payload, null, null);
        this.sendOneWay(destination, message);
    }

    public void sendOneWayOrderly(String destination, org.springframework.messaging.Message<?> message, String hashKey) {
        if (Objects.isNull(message) || Objects.isNull(message.getPayload())) {
            log.error("sendOneWayOrderly failed. destination:{}, message is null ", (Object)destination);
            throw new IllegalArgumentException("`message` and `message.payload` cannot be null");
        }
        try {
            Message rocketMsg = RocketMQUtil.convertToRocketMessage(this.objectMapper, this.charset, destination, message);
            this.producer.sendOneway(rocketMsg, this.messageQueueSelector, (Object)hashKey);
        }
        catch (Exception e) {
            log.error("sendOneWayOrderly failed. destination:{}, message:{}", (Object)destination, message);
            throw new MessagingException(e.getMessage(), (Throwable)e);
        }
    }

    public void sendOneWayOrderly(String destination, Object payload, String hashKey) {
        org.springframework.messaging.Message<?> message = this.doConvert(payload, null, null);
        this.sendOneWayOrderly(destination, message, hashKey);
    }

    public void afterPropertiesSet() throws Exception {
        if (this.producer != null) {
            this.producer.start();
        }
    }

    protected void doSend(String destination, org.springframework.messaging.Message<?> message) {
        SendResult sendResult = this.syncSend(destination, message);
        log.debug("send message to `{}` finished. result:{}", (Object)destination, (Object)sendResult);
    }

    protected org.springframework.messaging.Message<?> doConvert(Object payload, Map<String, Object> headers, MessagePostProcessor postProcessor) {
        String content;
        if (payload instanceof String) {
            content = (String)payload;
        } else {
            try {
                content = this.objectMapper.writeValueAsString(payload);
            }
            catch (JsonProcessingException e) {
                log.error("convert payload to String failed. payload:{}", payload);
                throw new RuntimeException("convert to payload to String failed.", e);
            }
        }
        MessageBuilder builder = MessageBuilder.withPayload((Object)content);
        if (headers != null) {
            builder.copyHeaders(headers);
        }
        builder.setHeaderIfAbsent("contentType", (Object)MimeTypeUtils.TEXT_PLAIN);
        org.springframework.messaging.Message message = builder.build();
        if (postProcessor != null) {
            message = postProcessor.postProcessMessage(message);
        }
        return message;
    }

    public void destroy() {
        if (Objects.nonNull(this.producer)) {
            this.producer.shutdown();
        }
        for (Map.Entry<String, TransactionMQProducer> kv : this.cache.entrySet()) {
            if (!Objects.nonNull(kv.getValue())) continue;
            kv.getValue().shutdown();
        }
        this.cache.clear();
    }

    private String getTxProducerGroupName(String name) {
        return name == null ? "rocketmq_transaction_default_global_name" : name;
    }

    private TransactionMQProducer stageMQProducer(String name) throws MessagingException {
        TransactionMQProducer cachedProducer = this.cache.get(name = this.getTxProducerGroupName(name));
        if (cachedProducer == null) {
            throw new MessagingException(String.format("Can not found MQProducer '%s' in cache! please define @RocketMQLocalTransactionListener class or invoke createOrGetStartedTransactionMQProducer() to create it firstly", name));
        }
        return cachedProducer;
    }

    public TransactionSendResult sendMessageInTransaction(String txProducerGroup, String destination, org.springframework.messaging.Message<?> message, Object arg) throws MessagingException {
        try {
            TransactionMQProducer txProducer = this.stageMQProducer(txProducerGroup);
            Message rocketMsg = RocketMQUtil.convertToRocketMessage(this.objectMapper, this.charset, destination, message);
            return txProducer.sendMessageInTransaction(rocketMsg, arg);
        }
        catch (MQClientException e) {
            throw RocketMQUtil.convert(e);
        }
    }

    public void removeTransactionMQProducer(String txProducerGroup) throws MessagingException {
        if (this.cache.containsKey(txProducerGroup = this.getTxProducerGroupName(txProducerGroup))) {
            DefaultMQProducer cachedProducer = (DefaultMQProducer)this.cache.get(txProducerGroup);
            cachedProducer.shutdown();
            this.cache.remove(txProducerGroup);
        }
    }

    public boolean createAndStartTransactionMQProducer(String txProducerGroup, RocketMQLocalTransactionListener transactionListener, ExecutorService executorService, RPCHook rpcHook) throws MessagingException {
        if (this.cache.containsKey(txProducerGroup = this.getTxProducerGroupName(txProducerGroup))) {
            log.info(String.format("get TransactionMQProducer '%s' from cache", txProducerGroup));
            return false;
        }
        TransactionMQProducer txProducer = this.createTransactionMQProducer(txProducerGroup, transactionListener, executorService, rpcHook);
        try {
            txProducer.start();
            this.cache.put(txProducerGroup, txProducer);
        }
        catch (MQClientException e) {
            throw RocketMQUtil.convert(e);
        }
        return true;
    }

    private TransactionMQProducer createTransactionMQProducer(String name, RocketMQLocalTransactionListener transactionListener, ExecutorService executorService, RPCHook rpcHook) {
        TransactionMQProducer txProducer;
        Assert.notNull((Object)this.producer, (String)"Property 'producer' is required");
        Assert.notNull((Object)transactionListener, (String)"Parameter 'transactionListener' is required");
        if (Objects.nonNull(rpcHook)) {
            txProducer = new TransactionMQProducer(name, rpcHook);
            txProducer.setVipChannelEnabled(false);
            txProducer.setInstanceName(RocketMQUtil.getInstanceName(rpcHook, name));
        } else {
            txProducer = new TransactionMQProducer(name);
        }
        txProducer.setTransactionListener(RocketMQUtil.convert(transactionListener));
        txProducer.setNamesrvAddr(this.producer.getNamesrvAddr());
        if (executorService != null) {
            txProducer.setExecutorService(executorService);
        }
        txProducer.setSendMsgTimeout(this.producer.getSendMsgTimeout());
        txProducer.setRetryTimesWhenSendFailed(this.producer.getRetryTimesWhenSendFailed());
        txProducer.setRetryTimesWhenSendAsyncFailed(this.producer.getRetryTimesWhenSendAsyncFailed());
        txProducer.setMaxMessageSize(this.producer.getMaxMessageSize());
        txProducer.setCompressMsgBodyOverHowmuch(this.producer.getCompressMsgBodyOverHowmuch());
        txProducer.setRetryAnotherBrokerWhenNotStoreOK(this.producer.isRetryAnotherBrokerWhenNotStoreOK());
        return txProducer;
    }
}

