/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.acl.common;

import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.SortedMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.acl.common.AclClientRPCHook;
import org.apache.rocketmq.acl.common.AclException;
import org.apache.rocketmq.acl.common.AclSigner;
import org.apache.rocketmq.acl.common.SessionCredentials;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.yaml.snakeyaml.Yaml;

public class AclUtils {
    private static final InternalLogger log = InternalLoggerFactory.getLogger((String)"RocketmqCommon");

    public static byte[] combineRequestContent(RemotingCommand request, SortedMap<String, String> fieldsMap) {
        try {
            StringBuilder sb = new StringBuilder("");
            for (Map.Entry<String, String> entry : fieldsMap.entrySet()) {
                if ("Signature".equals(entry.getKey())) continue;
                sb.append(entry.getValue());
            }
            return AclUtils.combineBytes(sb.toString().getBytes(SessionCredentials.CHARSET), request.getBody());
        }
        catch (Exception e) {
            throw new RuntimeException("incompatible exception.", e);
        }
    }

    public static byte[] combineBytes(byte[] b1, byte[] b2) {
        int size = (null != b1 ? b1.length : 0) + (null != b2 ? b2.length : 0);
        byte[] total = new byte[size];
        if (null != b1) {
            System.arraycopy(b1, 0, total, 0, b1.length);
        }
        if (null != b2) {
            System.arraycopy(b2, 0, total, b1.length, b2.length);
        }
        return total;
    }

    public static String calSignature(byte[] data, String secretKey) {
        String signature = AclSigner.calSignature(data, secretKey);
        return signature;
    }

    public static void verify(String netaddress, int index) {
        if (!AclUtils.isScope(netaddress, index)) {
            throw new AclException(String.format("netaddress examine scope Exception netaddress is %s", netaddress));
        }
    }

    public static String[] getAddreeStrArray(String netaddress, String four) {
        String[] fourStrArray = StringUtils.split((String)four.substring(1, four.length() - 1), (String)",");
        String address = netaddress.substring(0, netaddress.indexOf("{"));
        String[] addreeStrArray = new String[fourStrArray.length];
        for (int i = 0; i < fourStrArray.length; ++i) {
            addreeStrArray[i] = address + fourStrArray[i];
        }
        return addreeStrArray;
    }

    public static boolean isScope(String num, int index) {
        String[] strArray = StringUtils.split((String)num, (String)".");
        if (strArray.length != 4) {
            return false;
        }
        return AclUtils.isScope(strArray, index);
    }

    public static boolean isScope(String[] num, int index) {
        if (num.length <= index) {
            // empty if block
        }
        for (int i = 0; i < index; ++i) {
            if (AclUtils.isScope(num[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isScope(String num) {
        return AclUtils.isScope(Integer.valueOf(num.trim()));
    }

    public static boolean isScope(int num) {
        return num >= 0 && num <= 255;
    }

    public static boolean isAsterisk(String asterisk) {
        return asterisk.indexOf(42) > -1;
    }

    public static boolean isColon(String colon) {
        return colon.indexOf(44) > -1;
    }

    public static boolean isMinus(String minus) {
        return minus.indexOf(45) > -1;
    }

    public static <T> T getYamlDataObject(String path, Class<T> clazz) {
        Object object;
        Yaml ymal = new Yaml();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(new File(path));
            object = ymal.loadAs((InputStream)fis, clazz);
        }
        catch (FileNotFoundException ignore) {
            T t = null;
            return t;
        }
        catch (Exception e) {
            throw new AclException(e.getMessage());
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return (T)object;
    }

    public static RPCHook getAclRPCHook(String fileName) {
        JSONObject yamlDataObject = null;
        try {
            yamlDataObject = AclUtils.getYamlDataObject(fileName, JSONObject.class);
        }
        catch (Exception e) {
            log.error("convert yaml file to data object error, ", (Throwable)e);
            return null;
        }
        if (yamlDataObject == null || yamlDataObject.isEmpty()) {
            log.warn("Cannot find conf file :{}, acl isn't be enabled.", (Object)fileName);
            return null;
        }
        String accessKey = yamlDataObject.getString("accessKey");
        String secretKey = yamlDataObject.getString("secretKey");
        if (StringUtils.isBlank((CharSequence)accessKey) || StringUtils.isBlank((CharSequence)secretKey)) {
            log.warn("AccessKey or secretKey is blank, the acl is not enabled.");
            return null;
        }
        return new AclClientRPCHook(new SessionCredentials(accessKey, secretKey));
    }
}

