/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.usermodel;

import java.awt.Color;
import org.apache.poi.openxml4j.exceptions.OpenXML4JRuntimeException;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.sl.draw.DrawPaint;
import org.apache.poi.sl.usermodel.ColorStyle;
import org.apache.poi.sl.usermodel.PaintStyle;
import org.apache.poi.sl.usermodel.TextRun;
import org.apache.poi.xslf.model.CharacterPropertyFetcher;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xslf.usermodel.XSLFColor;
import org.apache.poi.xslf.usermodel.XSLFHyperlink;
import org.apache.poi.xslf.usermodel.XSLFPropertiesDelegate;
import org.apache.poi.xslf.usermodel.XSLFShape;
import org.apache.poi.xslf.usermodel.XSLFSheet;
import org.apache.poi.xslf.usermodel.XSLFSlide;
import org.apache.poi.xslf.usermodel.XSLFTextParagraph;
import org.apache.poi.xslf.usermodel.XSLFTextShape;
import org.apache.poi.xslf.usermodel.XSLFTheme;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTHyperlink;
import org.openxmlformats.schemas.drawingml.x2006.main.CTRegularTextRun;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSchemeColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTShapeStyle;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSolidColorFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextCharacterProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextField;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextFont;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextLineBreak;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextNormalAutofit;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextParagraphProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.STTextStrikeType;
import org.openxmlformats.schemas.drawingml.x2006.main.STTextUnderlineType;
import org.openxmlformats.schemas.presentationml.x2006.main.CTPlaceholder;

public class XSLFTextRun
implements TextRun {
    private final XmlObject _r;
    private final XSLFTextParagraph _p;

    protected XSLFTextRun(XmlObject r, XSLFTextParagraph p) {
        this._r = r;
        this._p = p;
        if (!(r instanceof CTRegularTextRun || r instanceof CTTextLineBreak || r instanceof CTTextField)) {
            throw new OpenXML4JRuntimeException("unsupported text run of type " + r.getClass());
        }
    }

    XSLFTextParagraph getParentParagraph() {
        return this._p;
    }

    public String getRawText() {
        if (this._r instanceof CTTextField) {
            return ((CTTextField)this._r).getT();
        }
        if (this._r instanceof CTTextLineBreak) {
            return "\n";
        }
        return ((CTRegularTextRun)this._r).getT();
    }

    String getRenderableText() {
        if (this._r instanceof CTTextField) {
            CTTextField tf = (CTTextField)this._r;
            XSLFSheet sheet = this._p.getParentShape().getSheet();
            if ("slidenum".equals(tf.getType()) && sheet instanceof XSLFSlide) {
                return Integer.toString(((XSLFSlide)sheet).getSlideNumber());
            }
            return tf.getT();
        }
        if (this._r instanceof CTTextLineBreak) {
            return "\n";
        }
        String txt = ((CTRegularTextRun)this._r).getT();
        TextRun.TextCap cap = this.getTextCap();
        StringBuffer buf = new StringBuffer();
        block4: for (int i = 0; i < txt.length(); ++i) {
            char c = txt.charAt(i);
            if (c == '\t') {
                buf.append("  ");
                continue;
            }
            switch (cap) {
                case ALL: {
                    buf.append(Character.toUpperCase(c));
                    continue block4;
                }
                case SMALL: {
                    buf.append(Character.toLowerCase(c));
                    continue block4;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    public void setText(String text) {
        if (this._r instanceof CTTextField) {
            ((CTTextField)this._r).setT(text);
        } else {
            if (this._r instanceof CTTextLineBreak) {
                return;
            }
            ((CTRegularTextRun)this._r).setT(text);
        }
    }

    public XmlObject getXmlObject() {
        return this._r;
    }

    public void setFontColor(Color color) {
        this.setFontColor((PaintStyle)DrawPaint.createSolidPaint((Color)color));
    }

    public void setFontColor(PaintStyle color) {
        if (!(color instanceof PaintStyle.SolidPaint)) {
            throw new IllegalArgumentException("Currently only SolidPaint is supported!");
        }
        PaintStyle.SolidPaint sp = (PaintStyle.SolidPaint)color;
        Color c = DrawPaint.applyColorTransform((ColorStyle)sp.getSolidColor());
        CTTextCharacterProperties rPr = this.getRPr(true);
        CTSolidColorFillProperties fill = rPr.isSetSolidFill() ? rPr.getSolidFill() : rPr.addNewSolidFill();
        XSLFColor col = new XSLFColor((XmlObject)fill, this.getParentParagraph().getParentShape().getSheet().getTheme(), fill.getSchemeClr());
        col.setColor(c);
    }

    public PaintStyle getFontColor() {
        final boolean hasPlaceholder = this.getParentParagraph().getParentShape().getPlaceholder() != null;
        CharacterPropertyFetcher<PaintStyle> fetcher = new CharacterPropertyFetcher<PaintStyle>(this._p.getIndentLevel()){

            @Override
            public boolean fetch(CTTextCharacterProperties props) {
                XSLFTheme theme;
                XSLFSheet sheet;
                PackagePart pp;
                XSLFPropertiesDelegate.XSLFFillProperties fp;
                PaintStyle ps;
                if (props == null) {
                    return false;
                }
                XSLFTextShape shape = XSLFTextRun.this._p.getParentShape();
                CTShapeStyle style = shape.getSpStyle();
                CTSchemeColor phClr = null;
                if (style != null && style.getFontRef() != null) {
                    phClr = style.getFontRef().getSchemeClr();
                }
                if ((ps = XSLFShape.selectPaint(fp = XSLFPropertiesDelegate.getFillDelegate((XmlObject)props), phClr, pp = (sheet = shape.getSheet()).getPackagePart(), theme = sheet.getTheme(), hasPlaceholder)) != null) {
                    this.setValue(ps);
                    return true;
                }
                return false;
            }
        };
        this.fetchCharacterProperty(fetcher);
        return (PaintStyle)fetcher.getValue();
    }

    public void setFontSize(Double fontSize) {
        CTTextCharacterProperties rPr = this.getRPr(true);
        if (fontSize == null) {
            if (rPr.isSetSz()) {
                rPr.unsetSz();
            }
        } else {
            if (fontSize < 1.0) {
                throw new IllegalArgumentException("Minimum font size is 1pt but was " + fontSize);
            }
            rPr.setSz((int)(100.0 * fontSize));
        }
    }

    public Double getFontSize() {
        double scale = 1.0;
        CTTextNormalAutofit afit = this.getParentParagraph().getParentShape().getTextBodyPr().getNormAutofit();
        if (afit != null) {
            scale = (double)afit.getFontScale() / 100000.0;
        }
        CharacterPropertyFetcher<Double> fetcher = new CharacterPropertyFetcher<Double>(this._p.getIndentLevel()){

            @Override
            public boolean fetch(CTTextCharacterProperties props) {
                if (props != null && props.isSetSz()) {
                    this.setValue((double)props.getSz() * 0.01);
                    return true;
                }
                return false;
            }
        };
        this.fetchCharacterProperty(fetcher);
        return fetcher.getValue() == null ? null : Double.valueOf((Double)fetcher.getValue() * scale);
    }

    public double getCharacterSpacing() {
        CharacterPropertyFetcher<Double> fetcher = new CharacterPropertyFetcher<Double>(this._p.getIndentLevel()){

            @Override
            public boolean fetch(CTTextCharacterProperties props) {
                if (props != null && props.isSetSpc()) {
                    this.setValue((double)props.getSpc() * 0.01);
                    return true;
                }
                return false;
            }
        };
        this.fetchCharacterProperty(fetcher);
        return fetcher.getValue() == null ? 0.0 : (Double)fetcher.getValue();
    }

    public void setCharacterSpacing(double spc) {
        CTTextCharacterProperties rPr = this.getRPr(true);
        if (spc == 0.0) {
            if (rPr.isSetSpc()) {
                rPr.unsetSpc();
            }
        } else {
            rPr.setSpc((int)(100.0 * spc));
        }
    }

    public void setFontFamily(String typeface) {
        this.setFontFamily(typeface, (byte)-1, (byte)-1, false);
    }

    public void setFontFamily(String typeface, byte charset, byte pictAndFamily, boolean isSymbol) {
        CTTextCharacterProperties rPr = this.getRPr(true);
        if (typeface == null) {
            if (rPr.isSetLatin()) {
                rPr.unsetLatin();
            }
            if (rPr.isSetCs()) {
                rPr.unsetCs();
            }
            if (rPr.isSetSym()) {
                rPr.unsetSym();
            }
        } else if (isSymbol) {
            CTTextFont font = rPr.isSetSym() ? rPr.getSym() : rPr.addNewSym();
            font.setTypeface(typeface);
        } else {
            CTTextFont latin = rPr.isSetLatin() ? rPr.getLatin() : rPr.addNewLatin();
            latin.setTypeface(typeface);
            if (charset != -1) {
                latin.setCharset(charset);
            }
            if (pictAndFamily != -1) {
                latin.setPitchFamily(pictAndFamily);
            }
        }
    }

    public String getFontFamily() {
        final XSLFTheme theme = this._p.getParentShape().getSheet().getTheme();
        CharacterPropertyFetcher<String> visitor = new CharacterPropertyFetcher<String>(this._p.getIndentLevel()){

            @Override
            public boolean fetch(CTTextCharacterProperties props) {
                CTTextFont font;
                if (props != null && (font = props.getLatin()) != null) {
                    String typeface = font.getTypeface();
                    if ("+mj-lt".equals(typeface)) {
                        typeface = theme.getMajorFont();
                    } else if ("+mn-lt".equals(typeface)) {
                        typeface = theme.getMinorFont();
                    }
                    this.setValue(typeface);
                    return true;
                }
                return false;
            }
        };
        this.fetchCharacterProperty(visitor);
        return (String)visitor.getValue();
    }

    public byte getPitchAndFamily() {
        CharacterPropertyFetcher<Byte> visitor = new CharacterPropertyFetcher<Byte>(this._p.getIndentLevel()){

            @Override
            public boolean fetch(CTTextCharacterProperties props) {
                CTTextFont font;
                if (props != null && (font = props.getLatin()) != null) {
                    this.setValue(font.getPitchFamily());
                    return true;
                }
                return false;
            }
        };
        this.fetchCharacterProperty(visitor);
        return visitor.getValue() == null ? (byte)0 : (Byte)visitor.getValue();
    }

    public void setStrikethrough(boolean strike) {
        this.getRPr(true).setStrike(strike ? STTextStrikeType.SNG_STRIKE : STTextStrikeType.NO_STRIKE);
    }

    public boolean isStrikethrough() {
        CharacterPropertyFetcher<Boolean> fetcher = new CharacterPropertyFetcher<Boolean>(this._p.getIndentLevel()){

            @Override
            public boolean fetch(CTTextCharacterProperties props) {
                if (props != null && props.isSetStrike()) {
                    this.setValue(props.getStrike() != STTextStrikeType.NO_STRIKE);
                    return true;
                }
                return false;
            }
        };
        this.fetchCharacterProperty(fetcher);
        return fetcher.getValue() == null ? false : (Boolean)fetcher.getValue();
    }

    public boolean isSuperscript() {
        CharacterPropertyFetcher<Boolean> fetcher = new CharacterPropertyFetcher<Boolean>(this._p.getIndentLevel()){

            @Override
            public boolean fetch(CTTextCharacterProperties props) {
                if (props != null && props.isSetBaseline()) {
                    this.setValue(props.getBaseline() > 0);
                    return true;
                }
                return false;
            }
        };
        this.fetchCharacterProperty(fetcher);
        return fetcher.getValue() == null ? false : (Boolean)fetcher.getValue();
    }

    public void setBaselineOffset(double baselineOffset) {
        this.getRPr(true).setBaseline((int)baselineOffset * 1000);
    }

    public void setSuperscript(boolean flag) {
        this.setBaselineOffset(flag ? 30.0 : 0.0);
    }

    public void setSubscript(boolean flag) {
        this.setBaselineOffset(flag ? -25.0 : 0.0);
    }

    public boolean isSubscript() {
        CharacterPropertyFetcher<Boolean> fetcher = new CharacterPropertyFetcher<Boolean>(this._p.getIndentLevel()){

            @Override
            public boolean fetch(CTTextCharacterProperties props) {
                if (props != null && props.isSetBaseline()) {
                    this.setValue(props.getBaseline() < 0);
                    return true;
                }
                return false;
            }
        };
        this.fetchCharacterProperty(fetcher);
        return fetcher.getValue() == null ? false : (Boolean)fetcher.getValue();
    }

    public TextRun.TextCap getTextCap() {
        CharacterPropertyFetcher<TextRun.TextCap> fetcher = new CharacterPropertyFetcher<TextRun.TextCap>(this._p.getIndentLevel()){

            @Override
            public boolean fetch(CTTextCharacterProperties props) {
                if (props != null && props.isSetCap()) {
                    int idx = props.getCap().intValue() - 1;
                    this.setValue(TextRun.TextCap.values()[idx]);
                    return true;
                }
                return false;
            }
        };
        this.fetchCharacterProperty(fetcher);
        return fetcher.getValue() == null ? TextRun.TextCap.NONE : (TextRun.TextCap)fetcher.getValue();
    }

    public void setBold(boolean bold) {
        this.getRPr(true).setB(bold);
    }

    public boolean isBold() {
        CharacterPropertyFetcher<Boolean> fetcher = new CharacterPropertyFetcher<Boolean>(this._p.getIndentLevel()){

            @Override
            public boolean fetch(CTTextCharacterProperties props) {
                if (props != null && props.isSetB()) {
                    this.setValue(props.getB());
                    return true;
                }
                return false;
            }
        };
        this.fetchCharacterProperty(fetcher);
        return fetcher.getValue() == null ? false : (Boolean)fetcher.getValue();
    }

    public void setItalic(boolean italic) {
        this.getRPr(true).setI(italic);
    }

    public boolean isItalic() {
        CharacterPropertyFetcher<Boolean> fetcher = new CharacterPropertyFetcher<Boolean>(this._p.getIndentLevel()){

            @Override
            public boolean fetch(CTTextCharacterProperties props) {
                if (props != null && props.isSetI()) {
                    this.setValue(props.getI());
                    return true;
                }
                return false;
            }
        };
        this.fetchCharacterProperty(fetcher);
        return fetcher.getValue() == null ? false : (Boolean)fetcher.getValue();
    }

    public void setUnderlined(boolean underline) {
        this.getRPr(true).setU(underline ? STTextUnderlineType.SNG : STTextUnderlineType.NONE);
    }

    public boolean isUnderlined() {
        CharacterPropertyFetcher<Boolean> fetcher = new CharacterPropertyFetcher<Boolean>(this._p.getIndentLevel()){

            @Override
            public boolean fetch(CTTextCharacterProperties props) {
                if (props != null && props.isSetU()) {
                    this.setValue(props.getU() != STTextUnderlineType.NONE);
                    return true;
                }
                return false;
            }
        };
        this.fetchCharacterProperty(fetcher);
        return fetcher.getValue() == null ? false : (Boolean)fetcher.getValue();
    }

    protected CTTextCharacterProperties getRPr(boolean create) {
        if (this._r instanceof CTTextField) {
            CTTextField tf = (CTTextField)this._r;
            if (tf.isSetRPr()) {
                return tf.getRPr();
            }
            if (create) {
                return tf.addNewRPr();
            }
        } else if (this._r instanceof CTTextLineBreak) {
            CTTextLineBreak tlb = (CTTextLineBreak)this._r;
            if (tlb.isSetRPr()) {
                return tlb.getRPr();
            }
            if (create) {
                return tlb.addNewRPr();
            }
        } else {
            CTRegularTextRun tr = (CTRegularTextRun)this._r;
            if (tr.isSetRPr()) {
                return tr.getRPr();
            }
            if (create) {
                return tr.addNewRPr();
            }
        }
        return null;
    }

    public String toString() {
        return "[" + this.getClass() + "]" + this.getRawText();
    }

    public XSLFHyperlink createHyperlink() {
        XSLFHyperlink hl = this.getHyperlink();
        if (hl != null) {
            return hl;
        }
        CTTextCharacterProperties rPr = this.getRPr(true);
        return new XSLFHyperlink(rPr.addNewHlinkClick(), this._p.getParentShape().getSheet());
    }

    public XSLFHyperlink getHyperlink() {
        CTTextCharacterProperties rPr = this.getRPr(false);
        if (rPr == null) {
            return null;
        }
        CTHyperlink hl = rPr.getHlinkClick();
        if (hl == null) {
            return null;
        }
        return new XSLFHyperlink(hl, this._p.getParentShape().getSheet());
    }

    private boolean fetchCharacterProperty(CharacterPropertyFetcher<?> fetcher) {
        XMLSlideShow ppt;
        CTTextParagraphProperties themeProps;
        XSLFTextShape shape = this._p.getParentShape();
        XSLFSheet sheet = shape.getSheet();
        CTTextCharacterProperties rPr = this.getRPr(false);
        if (rPr != null && fetcher.fetch(rPr)) {
            return true;
        }
        if (shape.fetchShapeProperty(fetcher)) {
            return true;
        }
        CTPlaceholder ph = shape.getCTPlaceholder();
        if (ph == null && (themeProps = (ppt = sheet.getSlideShow()).getDefaultParagraphStyle(this._p.getIndentLevel())) != null && fetcher.fetch(themeProps)) {
            return true;
        }
        CTTextParagraphProperties defaultProps = this._p.getDefaultMasterStyle();
        return defaultProps != null && fetcher.fetch(defaultProps);
    }

    void copy(XSLFTextRun r) {
        boolean strike;
        boolean underline;
        boolean italic;
        boolean bold;
        double srcFontSize;
        PaintStyle srcFontColor;
        String srcFontFamily = r.getFontFamily();
        if (srcFontFamily != null && !srcFontFamily.equals(this.getFontFamily())) {
            this.setFontFamily(srcFontFamily);
        }
        if ((srcFontColor = r.getFontColor()) != null && !srcFontColor.equals(this.getFontColor())) {
            this.setFontColor(srcFontColor);
        }
        if ((srcFontSize = r.getFontSize().doubleValue()) != this.getFontSize()) {
            this.setFontSize(srcFontSize);
        }
        if ((bold = r.isBold()) != this.isBold()) {
            this.setBold(bold);
        }
        if ((italic = r.isItalic()) != this.isItalic()) {
            this.setItalic(italic);
        }
        if ((underline = r.isUnderlined()) != this.isUnderlined()) {
            this.setUnderlined(underline);
        }
        if ((strike = r.isStrikethrough()) != this.isStrikethrough()) {
            this.setStrikethrough(strike);
        }
    }

    public TextRun.FieldType getFieldType() {
        CTTextField tf;
        if (this._r instanceof CTTextField && "slidenum".equals((tf = (CTTextField)this._r).getType())) {
            return TextRun.FieldType.SLIDE_NUMBER;
        }
        return null;
    }
}

