/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.extractor;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.poi.POIOLE2TextExtractor;
import org.apache.poi.POITextExtractor;
import org.apache.poi.POIXMLDocument;
import org.apache.poi.POIXMLRelation;
import org.apache.poi.POIXMLTextExtractor;
import org.apache.poi.hdgf.extractor.VisioTextExtractor;
import org.apache.poi.hpbf.extractor.PublisherTextExtractor;
import org.apache.poi.hslf.extractor.PowerPointExtractor;
import org.apache.poi.hsmf.MAPIMessage;
import org.apache.poi.hsmf.datatypes.AttachmentChunks;
import org.apache.poi.hsmf.extractor.OutlookTextExtactor;
import org.apache.poi.hssf.OldExcelFormatException;
import org.apache.poi.hssf.extractor.EventBasedExcelExtractor;
import org.apache.poi.hssf.extractor.ExcelExtractor;
import org.apache.poi.hssf.model.InternalWorkbook;
import org.apache.poi.hwpf.OldWordFileFormatException;
import org.apache.poi.hwpf.extractor.Word6Extractor;
import org.apache.poi.hwpf.extractor.WordExtractor;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.poi.poifs.filesystem.NotOLE2FileException;
import org.apache.poi.poifs.filesystem.OPOIFSFileSystem;
import org.apache.poi.poifs.filesystem.OfficeXmlFileException;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.xdgf.extractor.XDGFVisioExtractor;
import org.apache.poi.xslf.extractor.XSLFPowerPointExtractor;
import org.apache.poi.xslf.usermodel.XSLFRelation;
import org.apache.poi.xslf.usermodel.XSLFSlideShow;
import org.apache.poi.xssf.extractor.XSSFEventBasedExcelExtractor;
import org.apache.poi.xssf.extractor.XSSFExcelExtractor;
import org.apache.poi.xssf.usermodel.XSSFRelation;
import org.apache.poi.xwpf.extractor.XWPFWordExtractor;
import org.apache.xmlbeans.XmlException;

public class ExtractorFactory {
    public static final String CORE_DOCUMENT_REL = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument";
    protected static final String VISIO_DOCUMENT_REL = "http://schemas.microsoft.com/visio/2010/relationships/document";
    protected static final String STRICT_DOCUMENT_REL = "http://purl.oclc.org/ooxml/officeDocument/relationships/officeDocument";
    private static final ThreadLocal<Boolean> threadPreferEventExtractors = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private static Boolean allPreferEventExtractors;

    public static boolean getThreadPrefersEventExtractors() {
        return threadPreferEventExtractors.get();
    }

    public static Boolean getAllThreadsPreferEventExtractors() {
        return allPreferEventExtractors;
    }

    public static void setThreadPrefersEventExtractors(boolean preferEventExtractors) {
        threadPreferEventExtractors.set(preferEventExtractors);
    }

    public static void setAllThreadsPreferEventExtractors(Boolean preferEventExtractors) {
        allPreferEventExtractors = preferEventExtractors;
    }

    protected static boolean getPreferEventExtractor() {
        if (allPreferEventExtractors != null) {
            return allPreferEventExtractors;
        }
        return threadPreferEventExtractors.get();
    }

    public static POITextExtractor createExtractor(File f) throws IOException, InvalidFormatException, OpenXML4JException, XmlException {
        NPOIFSFileSystem fs = null;
        try {
            fs = new NPOIFSFileSystem(f);
            POIOLE2TextExtractor extractor = ExtractorFactory.createExtractor(fs);
            extractor.setFilesystem((Closeable)fs);
            return extractor;
        }
        catch (OfficeXmlFileException e) {
            if (fs != null) {
                fs.close();
            }
            return ExtractorFactory.createExtractor(OPCPackage.open(f.toString(), PackageAccess.READ));
        }
        catch (NotOLE2FileException ne) {
            if (fs != null) {
                fs.close();
            }
            throw new IllegalArgumentException("Your File was neither an OLE2 file, nor an OOXML file");
        }
        catch (OpenXML4JException e) {
            if (fs != null) {
                fs.close();
            }
            throw e;
        }
        catch (XmlException e) {
            if (fs != null) {
                fs.close();
            }
            throw e;
        }
        catch (IOException e) {
            if (fs != null) {
                fs.close();
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (fs != null) {
                fs.close();
            }
            throw e;
        }
    }

    public static POITextExtractor createExtractor(InputStream inp) throws IOException, InvalidFormatException, OpenXML4JException, XmlException {
        if (!inp.markSupported()) {
            inp = new PushbackInputStream(inp, 8);
        }
        if (NPOIFSFileSystem.hasPOIFSHeader((InputStream)inp)) {
            return ExtractorFactory.createExtractor(new NPOIFSFileSystem(inp));
        }
        if (POIXMLDocument.hasOOXMLHeader(inp)) {
            return ExtractorFactory.createExtractor(OPCPackage.open(inp));
        }
        throw new IllegalArgumentException("Your InputStream was neither an OLE2 stream, nor an OOXML stream");
    }

    public static POIXMLTextExtractor createExtractor(OPCPackage pkg) throws IOException, OpenXML4JException, XmlException {
        try {
            PackageRelationshipCollection core = pkg.getRelationshipsByType(CORE_DOCUMENT_REL);
            if (core.size() == 0) {
                core = pkg.getRelationshipsByType(STRICT_DOCUMENT_REL);
            }
            if (core.size() == 0 && (core = pkg.getRelationshipsByType(VISIO_DOCUMENT_REL)).size() == 1) {
                return new XDGFVisioExtractor(pkg);
            }
            if (core.size() != 1) {
                throw new IllegalArgumentException("Invalid OOXML Package received - expected 1 core document, found " + core.size());
            }
            PackagePart corePart = pkg.getPart(core.getRelationship(0));
            for (XSSFRelation xSSFRelation : XSSFExcelExtractor.SUPPORTED_TYPES) {
                if (!corePart.getContentType().equals(xSSFRelation.getContentType())) continue;
                if (ExtractorFactory.getPreferEventExtractor()) {
                    return new XSSFEventBasedExcelExtractor(pkg);
                }
                return new XSSFExcelExtractor(pkg);
            }
            for (POIXMLRelation pOIXMLRelation : XWPFWordExtractor.SUPPORTED_TYPES) {
                if (!corePart.getContentType().equals(pOIXMLRelation.getContentType())) continue;
                return new XWPFWordExtractor(pkg);
            }
            for (POIXMLRelation pOIXMLRelation : XSLFPowerPointExtractor.SUPPORTED_TYPES) {
                if (!corePart.getContentType().equals(pOIXMLRelation.getContentType())) continue;
                return new XSLFPowerPointExtractor(pkg);
            }
            if (XSLFRelation.THEME_MANAGER.getContentType().equals(corePart.getContentType())) {
                return new XSLFPowerPointExtractor(new XSLFSlideShow(pkg));
            }
            throw new IllegalArgumentException("No supported documents found in the OOXML package (found " + corePart.getContentType() + ")");
        }
        catch (IOException e) {
            pkg.revert();
            throw e;
        }
        catch (OpenXML4JException e) {
            pkg.revert();
            throw e;
        }
        catch (XmlException e) {
            pkg.revert();
            throw e;
        }
        catch (RuntimeException e) {
            pkg.revert();
            throw e;
        }
    }

    public static POIOLE2TextExtractor createExtractor(POIFSFileSystem fs) throws IOException, InvalidFormatException, OpenXML4JException, XmlException {
        return (POIOLE2TextExtractor)ExtractorFactory.createExtractor(fs.getRoot());
    }

    public static POIOLE2TextExtractor createExtractor(NPOIFSFileSystem fs) throws IOException, InvalidFormatException, OpenXML4JException, XmlException {
        return (POIOLE2TextExtractor)ExtractorFactory.createExtractor(fs.getRoot());
    }

    public static POIOLE2TextExtractor createExtractor(OPOIFSFileSystem fs) throws IOException, InvalidFormatException, OpenXML4JException, XmlException {
        return (POIOLE2TextExtractor)ExtractorFactory.createExtractor(fs.getRoot());
    }

    public static POITextExtractor createExtractor(DirectoryNode poifsDir) throws IOException, InvalidFormatException, OpenXML4JException, XmlException {
        for (String workbookName : InternalWorkbook.WORKBOOK_DIR_ENTRY_NAMES) {
            if (!poifsDir.hasEntry(workbookName)) continue;
            if (ExtractorFactory.getPreferEventExtractor()) {
                return new EventBasedExcelExtractor(poifsDir);
            }
            return new ExcelExtractor(poifsDir);
        }
        if (poifsDir.hasEntry("Book")) {
            throw new OldExcelFormatException("Old Excel Spreadsheet format (1-95) found. Please call OldExcelExtractor directly for basic text extraction");
        }
        if (poifsDir.hasEntry("WordDocument")) {
            try {
                return new WordExtractor(poifsDir);
            }
            catch (OldWordFileFormatException e) {
                return new Word6Extractor(poifsDir);
            }
        }
        if (poifsDir.hasEntry("PowerPoint Document")) {
            return new PowerPointExtractor(poifsDir);
        }
        if (poifsDir.hasEntry("VisioDocument")) {
            return new VisioTextExtractor(poifsDir);
        }
        if (poifsDir.hasEntry("Quill")) {
            return new PublisherTextExtractor(poifsDir);
        }
        if (poifsDir.hasEntry("__substg1.0_1000001E") || poifsDir.hasEntry("__substg1.0_1000001F") || poifsDir.hasEntry("__substg1.0_0047001E") || poifsDir.hasEntry("__substg1.0_0047001F") || poifsDir.hasEntry("__substg1.0_0037001E") || poifsDir.hasEntry("__substg1.0_0037001F")) {
            return new OutlookTextExtactor(poifsDir);
        }
        Iterator entries = poifsDir.getEntries();
        while (entries.hasNext()) {
            Entry entry = (Entry)entries.next();
            if (!entry.getName().equals("Package")) continue;
            OPCPackage pkg = OPCPackage.open((InputStream)poifsDir.createDocumentInputStream("Package"));
            return ExtractorFactory.createExtractor(pkg);
        }
        throw new IllegalArgumentException("No supported documents found in the OLE2 stream");
    }

    public static POITextExtractor[] getEmbededDocsTextExtractors(POIOLE2TextExtractor ext) throws IOException, InvalidFormatException, OpenXML4JException, XmlException {
        int i;
        ArrayList<Object> dirs = new ArrayList<Object>();
        ArrayList<ByteArrayInputStream> nonPOIFS = new ArrayList<ByteArrayInputStream>();
        DirectoryEntry root = ext.getRoot();
        if (root == null) {
            throw new IllegalStateException("The extractor didn't know which POIFS it came from!");
        }
        if (ext instanceof ExcelExtractor) {
            Iterator it = root.getEntries();
            while (it.hasNext()) {
                Entry entry = (Entry)it.next();
                if (!entry.getName().startsWith("MBD")) continue;
                dirs.add(entry);
            }
        } else if (ext instanceof WordExtractor) {
            try {
                DirectoryEntry op = (DirectoryEntry)root.getEntry("ObjectPool");
                Iterator it = op.getEntries();
                while (it.hasNext()) {
                    Entry entry = (Entry)it.next();
                    if (!entry.getName().startsWith("_")) continue;
                    dirs.add(entry);
                }
            }
            catch (FileNotFoundException e) {}
        } else if (!(ext instanceof PowerPointExtractor) && ext instanceof OutlookTextExtactor) {
            MAPIMessage msg = ((OutlookTextExtactor)ext).getMAPIMessage();
            for (AttachmentChunks attachment : msg.getAttachmentFiles()) {
                if (attachment.attachData != null) {
                    byte[] data = attachment.attachData.getValue();
                    nonPOIFS.add(new ByteArrayInputStream(data));
                    continue;
                }
                if (attachment.attachmentDirectory == null) continue;
                dirs.add(attachment.attachmentDirectory.getDirectory());
            }
        }
        if (dirs.size() == 0 && nonPOIFS.size() == 0) {
            return new POITextExtractor[0];
        }
        ArrayList<POITextExtractor> e = new ArrayList<POITextExtractor>();
        for (i = 0; i < dirs.size(); ++i) {
            e.add(ExtractorFactory.createExtractor((DirectoryNode)dirs.get(i)));
        }
        for (i = 0; i < nonPOIFS.size(); ++i) {
            try {
                e.add(ExtractorFactory.createExtractor((InputStream)nonPOIFS.get(i)));
                continue;
            }
            catch (IllegalArgumentException ie) {
                continue;
            }
            catch (XmlException xe) {
                throw new IOException(xe.getMessage());
            }
            catch (OpenXML4JException oe) {
                throw new IOException(oe.getMessage());
            }
        }
        return e.toArray(new POITextExtractor[e.size()]);
    }

    public static POITextExtractor[] getEmbededDocsTextExtractors(POIXMLTextExtractor ext) {
        throw new IllegalStateException("Not yet supported");
    }
}

