/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.namefind;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import opennlp.tools.cmdline.AbstractTrainerTool;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.namefind.TrainingParams;
import opennlp.tools.cmdline.params.TrainingToolParams;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.namefind.NameSampleTypeFilter;
import opennlp.tools.namefind.TokenNameFinderModel;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.model.ArtifactSerializer;
import opennlp.tools.util.model.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TokenNameFinderTrainerTool
extends AbstractTrainerTool<NameSample, TrainerToolParams> {
    public TokenNameFinderTrainerTool() {
        super(NameSample.class, TrainerToolParams.class);
    }

    @Override
    public String getShortDescription() {
        return "trainer for the learnable name finder";
    }

    static byte[] openFeatureGeneratorBytes(String featureGenDescriptorFile) {
        if (featureGenDescriptorFile != null) {
            return TokenNameFinderTrainerTool.openFeatureGeneratorBytes(new File(featureGenDescriptorFile));
        }
        return null;
    }

    static byte[] openFeatureGeneratorBytes(File featureGenDescriptorFile) {
        byte[] featureGeneratorBytes = null;
        if (featureGenDescriptorFile != null) {
            FileInputStream bytesIn = CmdLineUtil.openInFile(featureGenDescriptorFile);
            try {
                featureGeneratorBytes = ModelUtil.read(bytesIn);
            }
            catch (IOException e) {
                throw new TerminateToolException(-1, "IO error while reading training data or indexing data: " + e.getMessage(), e);
            }
            finally {
                try {
                    ((InputStream)bytesIn).close();
                }
                catch (IOException e) {}
            }
        }
        return featureGeneratorBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> loadResources(File resourcePath) {
        HashMap<String, Object> resources = new HashMap<String, Object>();
        if (resourcePath != null) {
            File[] resourceFiles;
            Map<String, ArtifactSerializer> artifactSerializers = TokenNameFinderModel.createArtifactSerializers();
            for (File resourceFile : resourceFiles = resourcePath.listFiles()) {
                String ending;
                ArtifactSerializer serializer;
                String resourceName = resourceFile.getName();
                int lastDot = resourceName.lastIndexOf(46);
                if (lastDot == -1 || (serializer = artifactSerializers.get(ending = resourceName.substring(lastDot + 1))) == null) continue;
                FileInputStream resoruceIn = CmdLineUtil.openInFile(resourceFile);
                try {
                    resources.put(resourceName, serializer.create(resoruceIn));
                }
                catch (InvalidFormatException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        ((InputStream)resoruceIn).close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return resources;
    }

    static Map<String, Object> loadResources(String resourceDirectory) {
        if (resourceDirectory != null) {
            File resourcePath = new File(resourceDirectory);
            return TokenNameFinderTrainerTool.loadResources(resourcePath);
        }
        return new HashMap<String, Object>();
    }

    @Override
    public void run(String format, String[] args) {
        TokenNameFinderModel model;
        super.run(format, args);
        this.mlParams = CmdLineUtil.loadTrainingParameters(((TrainerToolParams)this.params).getParams(), false);
        if (this.mlParams == null) {
            this.mlParams = ModelUtil.createTrainingParameters(((TrainerToolParams)this.params).getIterations(), ((TrainerToolParams)this.params).getCutoff());
        }
        File modelOutFile = ((TrainerToolParams)this.params).getModel();
        byte[] featureGeneratorBytes = TokenNameFinderTrainerTool.openFeatureGeneratorBytes(((TrainerToolParams)this.params).getFeaturegen());
        Map<String, Object> resources = TokenNameFinderTrainerTool.loadResources(((TrainerToolParams)this.params).getResources());
        CmdLineUtil.checkOutputFile("name finder model", modelOutFile);
        if (((TrainerToolParams)this.params).getNameTypes() != null) {
            String[] nameTypes = ((TrainerToolParams)this.params).getNameTypes().split(",");
            this.sampleStream = new NameSampleTypeFilter(nameTypes, (ObjectStream<NameSample>)this.sampleStream);
        }
        try {
            model = NameFinderME.train(((TrainerToolParams)this.params).getLang(), ((TrainerToolParams)this.params).getType(), (ObjectStream<NameSample>)this.sampleStream, this.mlParams, featureGeneratorBytes, resources);
        }
        catch (IOException e) {
            throw new TerminateToolException(-1, "IO error while reading training data or indexing data: " + e.getMessage(), e);
        }
        finally {
            try {
                this.sampleStream.close();
            }
            catch (IOException e) {}
        }
        CmdLineUtil.writeModel("name finder", modelOutFile, model);
    }

    static interface TrainerToolParams
    extends TrainingParams,
    TrainingToolParams {
        @ArgumentParser.OptionalParameter
        @ArgumentParser.ParameterDescription(valueName="types", description="name types to use for training")
        public String getNameTypes();
    }
}

