/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.events;

import java.io.File;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.events.WagonEvent;
import org.apache.maven.wagon.resource.Resource;

public class TransferEvent
extends WagonEvent {
    public static final int TRANSFER_INITIATED = 0;
    public static final int TRANSFER_STARTED = 1;
    public static final int TRANSFER_COMPLETED = 2;
    public static final int TRANSFER_PROGRESS = 3;
    public static final int TRANSFER_ERROR = 4;
    public static final int REQUEST_GET = 5;
    public static final int REQUEST_PUT = 6;
    private Resource resource;
    private int eventType;
    private int requestType;
    private Exception exception;
    private File localFile;

    public TransferEvent(Wagon wagon, Resource resource, int eventType, int requestType) {
        super(wagon);
        this.resource = resource;
        this.setEventType(eventType);
        this.setRequestType(requestType);
    }

    public TransferEvent(Wagon wagon, Resource resource, Exception exception, int requestType) {
        this(wagon, resource, 4, requestType);
        this.exception = exception;
    }

    public Resource getResource() {
        return this.resource;
    }

    public Exception getException() {
        return this.exception;
    }

    public int getRequestType() {
        return this.requestType;
    }

    public void setRequestType(int requestType) {
        switch (requestType) {
            case 6: {
                break;
            }
            case 5: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal request type: " + requestType);
            }
        }
        this.requestType = requestType;
    }

    public int getEventType() {
        return this.eventType;
    }

    public void setEventType(int eventType) {
        switch (eventType) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal event type: " + eventType);
            }
        }
        this.eventType = eventType;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public File getLocalFile() {
        return this.localFile;
    }

    public void setLocalFile(File localFile) {
        this.localFile = localFile;
    }
}

