/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter;

import javax.annotation.Nonnull;
import org.apache.maven.surefire.booter.AbstractPathConfiguration;
import org.apache.maven.surefire.booter.ClassLoaderConfiguration;
import org.apache.maven.surefire.booter.ClasspathConfiguration;

public class StartupConfiguration {
    private static final String SUREFIRE_TEST_CLASSPATH = "surefire.test.class.path";
    private final String providerClassName;
    private final AbstractPathConfiguration classpathConfiguration;
    private final ClassLoaderConfiguration classLoaderConfiguration;
    private final boolean isForkRequested;
    private final boolean isInForkedVm;

    public StartupConfiguration(@Nonnull String providerClassName, @Nonnull AbstractPathConfiguration classpathConfiguration, @Nonnull ClassLoaderConfiguration classLoaderConfiguration, boolean isForkRequested, boolean inForkedVm) {
        this.classpathConfiguration = classpathConfiguration;
        this.classLoaderConfiguration = classLoaderConfiguration;
        this.isForkRequested = isForkRequested;
        this.providerClassName = providerClassName;
        this.isInForkedVm = inForkedVm;
    }

    public boolean isProviderMainClass() {
        return this.providerClassName.endsWith("#main");
    }

    public static StartupConfiguration inForkedVm(String providerClassName, ClasspathConfiguration classpathConfiguration, ClassLoaderConfiguration classLoaderConfiguration) {
        return new StartupConfiguration(providerClassName, classpathConfiguration, classLoaderConfiguration, true, true);
    }

    public AbstractPathConfiguration getClasspathConfiguration() {
        return this.classpathConfiguration;
    }

    @Deprecated
    public boolean useSystemClassLoader() {
        return this.classLoaderConfiguration.isUseSystemClassLoader() && (this.isInForkedVm || this.isForkRequested);
    }

    public boolean isManifestOnlyJarRequestedAndUsable() {
        return this.classLoaderConfiguration.isManifestOnlyJarRequestedAndUsable();
    }

    public String getProviderClassName() {
        return this.providerClassName;
    }

    public String getActualClassName() {
        return this.isProviderMainClass() ? StartupConfiguration.stripEnd(this.providerClassName, "#main") : this.providerClassName;
    }

    private static String stripEnd(String str, String strip) {
        int end;
        if (str == null) {
            return null;
        }
        if (strip == null) {
            for (end = str.length(); end != 0 && Character.isWhitespace(str.charAt(end - 1)); --end) {
            }
        } else {
            while (end != 0 && strip.indexOf(str.charAt(end - 1)) != -1) {
                --end;
            }
        }
        return str.substring(0, end);
    }

    public ClassLoaderConfiguration getClassLoaderConfiguration() {
        return this.classLoaderConfiguration;
    }

    public boolean isShadefire() {
        return this.providerClassName.startsWith("org.apache.maven.surefire.shadefire");
    }

    public void writeSurefireTestClasspathProperty() {
        this.getClasspathConfiguration().getTestClasspath().writeToSystemProperty(SUREFIRE_TEST_CLASSPATH);
    }
}

