/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.runorder;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.surefire.runorder.PrioritizedTest;

public class ThreadedExecutionScheduler {
    private final int numThreads;
    private final int[] runTime;
    private final List<Class<?>>[] lists;

    public ThreadedExecutionScheduler(int numThreads) {
        this.numThreads = numThreads;
        this.runTime = new int[numThreads];
        this.lists = new List[numThreads];
        for (int i = 0; i < numThreads; ++i) {
            this.lists[i] = new ArrayList();
        }
    }

    public void addTest(PrioritizedTest prioritizedTest) {
        int leastBusySlot;
        int n = leastBusySlot = this.findLeastBusySlot();
        this.runTime[n] = this.runTime[n] + prioritizedTest.getTotalRuntime();
        this.lists[leastBusySlot].add(prioritizedTest.getClazz());
    }

    public List<Class<?>> getResult() {
        boolean added;
        ArrayList result = new ArrayList();
        int index = 0;
        do {
            added = false;
            for (int i = 0; i < this.numThreads; ++i) {
                if (this.lists[i].size() <= index) continue;
                result.add(this.lists[i].get(index));
                added = true;
            }
            ++index;
        } while (added);
        return result;
    }

    private int findLeastBusySlot() {
        int leastBusy = 0;
        int minRuntime = this.runTime[0];
        for (int i = 1; i < this.numThreads; ++i) {
            if (this.runTime[i] >= minRuntime) continue;
            leastBusy = i;
            minRuntime = this.runTime[i];
        }
        return leastBusy;
    }
}

