/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.shade.org.codehaus.plexus.util.dag;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.maven.surefire.shade.org.codehaus.plexus.util.dag.DAG;
import org.apache.maven.surefire.shade.org.codehaus.plexus.util.dag.Vertex;

public class CycleDetector {
    private static final Integer NOT_VISTITED = new Integer(0);
    private static final Integer VISITING = new Integer(1);
    private static final Integer VISITED = new Integer(2);

    public static List hasCycle(DAG graph) {
        Vertex vertex;
        List verticies = graph.getVerticies();
        HashMap vertexStateMap = new HashMap();
        List retValue = null;
        Iterator iter = verticies.iterator();
        while (iter.hasNext() && (!CycleDetector.isNotVisited(vertex = (Vertex)iter.next(), vertexStateMap) || (retValue = CycleDetector.introducesCycle(vertex, vertexStateMap)) == null)) {
        }
        return retValue;
    }

    public static List introducesCycle(Vertex vertex, Map vertexStateMap) {
        LinkedList cycleStack = new LinkedList();
        boolean hasCycle = CycleDetector.dfsVisit(vertex, cycleStack, vertexStateMap);
        if (hasCycle) {
            String label = (String)cycleStack.getFirst();
            int pos = cycleStack.lastIndexOf(label);
            List cycle = cycleStack.subList(0, pos + 1);
            Collections.reverse(cycle);
            return cycle;
        }
        return null;
    }

    public static List introducesCycle(Vertex vertex) {
        HashMap vertexStateMap = new HashMap();
        return CycleDetector.introducesCycle(vertex, vertexStateMap);
    }

    private static boolean isNotVisited(Vertex vertex, Map vertexStateMap) {
        if (!vertexStateMap.containsKey(vertex)) {
            return true;
        }
        Integer state = (Integer)vertexStateMap.get(vertex);
        return NOT_VISTITED.equals(state);
    }

    private static boolean isVisiting(Vertex vertex, Map vertexStateMap) {
        Integer state = (Integer)vertexStateMap.get(vertex);
        return VISITING.equals(state);
    }

    private static boolean dfsVisit(Vertex vertex, LinkedList cycle, Map vertexStateMap) {
        cycle.addFirst(vertex.getLabel());
        vertexStateMap.put(vertex, VISITING);
        List verticies = vertex.getChildren();
        Iterator iter = verticies.iterator();
        while (iter.hasNext()) {
            Vertex v = (Vertex)iter.next();
            if (CycleDetector.isNotVisited(v, vertexStateMap)) {
                boolean hasCycle = CycleDetector.dfsVisit(v, cycle, vertexStateMap);
                if (!hasCycle) continue;
                return true;
            }
            if (!CycleDetector.isVisiting(v, vertexStateMap)) continue;
            cycle.addFirst(v.getLabel());
            return true;
        }
        vertexStateMap.put(vertex, VISITED);
        cycle.removeFirst();
        return false;
    }
}

