/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.booterclient.output;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.maven.plugin.surefire.booterclient.lazytestprovider.NotifiableTestStream;
import org.apache.maven.plugin.surefire.booterclient.output.DeserializedStacktraceWriter;
import org.apache.maven.plugin.surefire.booterclient.output.InPluginProcessDumpSingleton;
import org.apache.maven.plugin.surefire.log.api.ConsoleLogger;
import org.apache.maven.plugin.surefire.report.DefaultReporterFactory;
import org.apache.maven.surefire.booter.Shutdown;
import org.apache.maven.surefire.report.CategorizedReportEntry;
import org.apache.maven.surefire.report.ConsoleOutputReceiver;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.RunListener;
import org.apache.maven.surefire.report.StackTraceWriter;
import org.apache.maven.surefire.report.TestSetReportEntry;
import org.apache.maven.surefire.shade.common.org.apache.maven.shared.utils.cli.StreamConsumer;
import org.apache.maven.surefire.util.internal.StringUtils;

public class ForkClient
implements StreamConsumer {
    private static final String PRINTABLE_JVM_NATIVE_STREAM = "Listening for transport dt_socket at address:";
    private static final long START_TIME_ZERO = 0L;
    private static final long START_TIME_NEGATIVE_TIMEOUT = -1L;
    private final DefaultReporterFactory defaultReporterFactory;
    private final Map<String, String> testVmSystemProperties = new ConcurrentHashMap<String, String>();
    private final NotifiableTestStream notifiableTestStream;
    private final Queue<String> testsInProgress = new ConcurrentLinkedQueue<String>();
    private final AtomicLong testSetStartedAt = new AtomicLong(0L);
    private final ConsoleLogger log;
    private final AtomicBoolean printedErrorStream;
    private final int forkNumber;
    private RunListener testSetReporter;
    private volatile boolean saidGoodBye;
    private volatile StackTraceWriter errorInFork;

    public ForkClient(DefaultReporterFactory defaultReporterFactory, NotifiableTestStream notifiableTestStream, ConsoleLogger log, AtomicBoolean printedErrorStream, int forkNumber) {
        this.defaultReporterFactory = defaultReporterFactory;
        this.notifiableTestStream = notifiableTestStream;
        this.log = log;
        this.printedErrorStream = printedErrorStream;
        this.forkNumber = forkNumber;
    }

    protected void stopOnNextTest() {
    }

    public void kill() {
        if (!this.saidGoodBye) {
            this.notifiableTestStream.shutdown(Shutdown.KILL);
        }
    }

    public final void tryToTimeout(long currentTimeMillis, int forkedProcessTimeoutInSeconds) {
        if (forkedProcessTimeoutInSeconds > 0) {
            long forkedProcessTimeoutInMillis = 1000 * forkedProcessTimeoutInSeconds;
            long startedAt = this.testSetStartedAt.get();
            if (startedAt > 0L && currentTimeMillis - startedAt >= forkedProcessTimeoutInMillis) {
                this.testSetStartedAt.set(-1L);
                this.notifiableTestStream.shutdown(Shutdown.KILL);
            }
        }
    }

    public final DefaultReporterFactory getDefaultReporterFactory() {
        return this.defaultReporterFactory;
    }

    @Override
    public final void consumeLine(String s) {
        if (StringUtils.isNotBlank((String)s)) {
            this.processLine(s);
        }
    }

    private void setCurrentStartTime() {
        if (this.testSetStartedAt.get() == 0L) {
            this.testSetStartedAt.compareAndSet(0L, System.currentTimeMillis());
        }
    }

    public final boolean hadTimeout() {
        return this.testSetStartedAt.get() == -1L;
    }

    private RunListener getTestSetReporter() {
        if (this.testSetReporter == null) {
            this.testSetReporter = this.defaultReporterFactory.createReporter();
        }
        return this.testSetReporter;
    }

    private void processLine(String event) {
        OperationalData op;
        try {
            op = new OperationalData(event);
        }
        catch (RuntimeException e) {
            this.logStreamWarning(e, event);
            return;
        }
        String remaining = op.getData();
        switch (op.getOperationId()) {
            case 49: {
                this.getTestSetReporter().testSetStarting(this.createReportEntry(remaining));
                this.setCurrentStartTime();
                break;
            }
            case 50: {
                this.testsInProgress.clear();
                this.getTestSetReporter().testSetCompleted(this.createReportEntry(remaining, this.testVmSystemProperties));
                break;
            }
            case 53: {
                TestSetReportEntry reportEntry = this.createReportEntry(remaining);
                this.testsInProgress.offer(reportEntry.getSourceName());
                this.getTestSetReporter().testStarting((ReportEntry)this.createReportEntry(remaining));
                break;
            }
            case 54: {
                TestSetReportEntry reportEntry = this.createReportEntry(remaining);
                this.testsInProgress.remove(reportEntry.getSourceName());
                this.getTestSetReporter().testSucceeded((ReportEntry)this.createReportEntry(remaining));
                break;
            }
            case 56: {
                TestSetReportEntry reportEntry = this.createReportEntry(remaining);
                this.testsInProgress.remove(reportEntry.getSourceName());
                this.getTestSetReporter().testFailed((ReportEntry)this.createReportEntry(remaining));
                break;
            }
            case 57: {
                TestSetReportEntry reportEntry = this.createReportEntry(remaining);
                this.testsInProgress.remove(reportEntry.getSourceName());
                this.getTestSetReporter().testSkipped((ReportEntry)this.createReportEntry(remaining));
                break;
            }
            case 55: {
                TestSetReportEntry reportEntry = this.createReportEntry(remaining);
                this.testsInProgress.remove(reportEntry.getSourceName());
                this.getTestSetReporter().testError((ReportEntry)this.createReportEntry(remaining));
                break;
            }
            case 71: {
                TestSetReportEntry reportEntry = this.createReportEntry(remaining);
                this.testsInProgress.remove(reportEntry.getSourceName());
                this.getTestSetReporter().testAssumptionFailure((ReportEntry)this.createReportEntry(remaining));
                break;
            }
            case 73: {
                int keyEnd = remaining.indexOf(",");
                StringBuilder key = new StringBuilder();
                StringBuilder value = new StringBuilder();
                StringUtils.unescapeString((StringBuilder)key, (CharSequence)remaining.substring(0, keyEnd));
                StringUtils.unescapeString((StringBuilder)value, (CharSequence)remaining.substring(keyEnd + 1));
                this.testVmSystemProperties.put(key.toString(), value.toString());
                break;
            }
            case 51: {
                this.writeTestOutput(remaining, true);
                break;
            }
            case 52: {
                this.writeTestOutput(remaining, false);
                break;
            }
            case 72: {
                this.getOrCreateConsoleLogger().info(this.createConsoleMessage(remaining));
                break;
            }
            case 78: {
                this.notifiableTestStream.provideNewTest();
                break;
            }
            case 88: {
                this.errorInFork = this.deserializeStackTraceWriter(new StringTokenizer(remaining, ","));
                break;
            }
            case 90: {
                this.saidGoodBye = true;
                this.notifiableTestStream.acknowledgeByeEventReceived();
                break;
            }
            case 83: {
                this.stopOnNextTest();
                break;
            }
            case 68: {
                this.getOrCreateConsoleLogger().debug(this.createConsoleMessage(remaining));
                break;
            }
            case 87: {
                this.getOrCreateConsoleLogger().warning(this.createConsoleMessage(remaining));
                break;
            }
            default: {
                this.logStreamWarning(event);
            }
        }
    }

    private void logStreamWarning(String event) {
        this.logStreamWarning(null, event);
    }

    private void logStreamWarning(Throwable e, String event) {
        if (event == null || !event.contains(PRINTABLE_JVM_NATIVE_STREAM)) {
            File dump;
            String msg = "Corrupted STDOUT by directly writing to native stream in forked JVM " + this.forkNumber + ".";
            InPluginProcessDumpSingleton util = InPluginProcessDumpSingleton.getSingleton();
            File reportsDir = this.defaultReporterFactory.getReportsDirectory();
            File file = dump = e == null ? util.dumpStreamText(msg + " Stream '" + event + "'.", reportsDir, this.forkNumber) : util.dumpStreamException(e, msg + " Stream '" + event + "'.", reportsDir, this.forkNumber);
            if (this.printedErrorStream.compareAndSet(false, true)) {
                this.log.warning(msg + " See FAQ web page and the dump file " + dump.getAbsolutePath());
            }
            if (this.log.isDebugEnabled() && event != null) {
                this.log.debug(event);
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug(event);
        } else if (this.log.isInfoEnabled()) {
            this.log.info(event);
        } else {
            System.out.println(event);
        }
    }

    private void writeTestOutput(String remaining, boolean isStdout) {
        int csNameEnd = remaining.indexOf(44);
        String charsetName = remaining.substring(0, csNameEnd);
        String byteEncoded = remaining.substring(csNameEnd + 1);
        ByteBuffer unescaped = StringUtils.unescapeBytes((String)byteEncoded, (String)charsetName);
        if (unescaped.hasArray()) {
            byte[] convertedBytes = unescaped.array();
            this.getOrCreateConsoleOutputReceiver().writeTestOutput(convertedBytes, unescaped.position(), unescaped.remaining(), isStdout);
        } else {
            byte[] convertedBytes = new byte[unescaped.remaining()];
            unescaped.get(convertedBytes, 0, unescaped.remaining());
            this.getOrCreateConsoleOutputReceiver().writeTestOutput(convertedBytes, 0, convertedBytes.length, isStdout);
        }
    }

    public final void consumeMultiLineContent(String s) throws IOException {
        BufferedReader stringReader = new BufferedReader(new StringReader(s));
        String s1 = stringReader.readLine();
        while (s1 != null) {
            this.consumeLine(s1);
            s1 = stringReader.readLine();
        }
    }

    private String createConsoleMessage(String remaining) {
        return this.unescape(remaining);
    }

    private TestSetReportEntry createReportEntry(String untokenized) {
        return this.createReportEntry(untokenized, Collections.emptyMap());
    }

    private TestSetReportEntry createReportEntry(String untokenized, Map<String, String> systemProperties) {
        StringTokenizer tokens = new StringTokenizer(untokenized, ",");
        try {
            String source = this.nullableCsv(tokens.nextToken());
            String name = this.nullableCsv(tokens.nextToken());
            String group = this.nullableCsv(tokens.nextToken());
            String message = this.nullableCsv(tokens.nextToken());
            String elapsedStr = tokens.nextToken();
            Integer elapsed = "null".equals(elapsedStr) ? null : Integer.decode(elapsedStr);
            StackTraceWriter stackTraceWriter = tokens.hasMoreTokens() ? this.deserializeStackTraceWriter(tokens) : null;
            return CategorizedReportEntry.reportEntry((String)source, (String)name, (String)group, (StackTraceWriter)stackTraceWriter, (Integer)elapsed, (String)message, systemProperties);
        }
        catch (RuntimeException e) {
            throw new RuntimeException(untokenized, e);
        }
    }

    private StackTraceWriter deserializeStackTraceWriter(StringTokenizer tokens) {
        String stackTraceMessage = this.nullableCsv(tokens.nextToken());
        String smartStackTrace = this.nullableCsv(tokens.nextToken());
        String stackTrace = tokens.hasMoreTokens() ? this.nullableCsv(tokens.nextToken()) : null;
        boolean hasTrace = stackTrace != null;
        return hasTrace ? new DeserializedStacktraceWriter(stackTraceMessage, smartStackTrace, stackTrace) : null;
    }

    private String nullableCsv(String source) {
        return "null".equals(source) ? null : this.unescape(source);
    }

    private String unescape(String source) {
        StringBuilder stringBuffer = new StringBuilder(source.length());
        StringUtils.unescapeString((StringBuilder)stringBuffer, (CharSequence)source);
        return stringBuffer.toString();
    }

    public final Map<String, String> getTestVmSystemProperties() {
        return Collections.unmodifiableMap(this.testVmSystemProperties);
    }

    public final RunListener getReporter() {
        return this.getTestSetReporter();
    }

    private ConsoleOutputReceiver getOrCreateConsoleOutputReceiver() {
        return (ConsoleOutputReceiver)this.getTestSetReporter();
    }

    private ConsoleLogger getOrCreateConsoleLogger() {
        return (ConsoleLogger)this.getTestSetReporter();
    }

    public void close(boolean hadTimeout) {
    }

    public final boolean isSaidGoodBye() {
        return this.saidGoodBye;
    }

    public final StackTraceWriter getErrorInFork() {
        return this.errorInFork;
    }

    public final boolean isErrorInFork() {
        return this.errorInFork != null;
    }

    public Set<String> testsInProgress() {
        return new TreeSet<String>(this.testsInProgress);
    }

    public boolean hasTestsInProgress() {
        return !this.testsInProgress.isEmpty();
    }

    private static final class OperationalData {
        private final byte operationId;
        private final String data;

        OperationalData(String event) {
            this.operationId = (byte)event.charAt(0);
            int comma = event.indexOf(",", 3);
            if (comma < 0) {
                throw new IllegalArgumentException("Stream stdin corrupted. Expected comma after third character in command '" + event + "'.");
            }
            int rest = event.indexOf(",", comma);
            this.data = event.substring(rest + 1);
        }

        byte getOperationId() {
            return this.operationId;
        }

        String getData() {
            return this.data;
        }
    }
}

