/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.report;

import java.io.BufferedOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import org.apache.maven.plugin.surefire.report.AbstractTextReporter;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.ReporterException;

public abstract class AbstractConsoleReporter
extends AbstractTextReporter {
    private static final String TEST_SET_STARTING_PREFIX = "Running ";
    private static final String TEST_SET_STARTING_GROUP_PREFIX = " (of ";
    private static final String TEST_SET_STARTING_GROUP_SUFIX = ")";
    private static final int BUFFER_SIZE = 4096;
    private static final PrintStream ORIGINAL_SYSTEM_OUT = System.out;

    AbstractConsoleReporter(boolean trimStackTrace, String format) {
        super(AbstractConsoleReporter.getPrintWriter(), trimStackTrace, format);
    }

    private static PrintWriter getPrintWriter() {
        return new PrintWriter(new OutputStreamWriter(new BufferedOutputStream(ORIGINAL_SYSTEM_OUT, 4096)));
    }

    public void testSetStarting(ReportEntry report) throws ReporterException {
        super.testSetStarting(report);
        this.writeMessage(AbstractConsoleReporter.getTestSetStartingMessage(report));
    }

    static String getTestSetStartingMessage(ReportEntry report) {
        StringBuffer message = new StringBuffer();
        message.append(TEST_SET_STARTING_PREFIX);
        message.append(report.getName());
        if (report.getGroup() != null && !report.getName().equals(report.getGroup())) {
            message.append(TEST_SET_STARTING_GROUP_PREFIX);
            message.append(report.getGroup());
            message.append(TEST_SET_STARTING_GROUP_SUFIX);
        }
        message.append("\n");
        return message.toString();
    }
}

