/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.mapping;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.shared.mapping.DashClassifierValueSource;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.ObjectBasedValueSource;
import org.codehaus.plexus.interpolation.RegexBasedInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;

public final class MappingUtils {
    public static final String DEFAULT_FILE_NAME_MAPPING = "@{artifactId}@-@{baseVersion}@.@{extension}@";
    public static final String DEFAULT_FILE_NAME_MAPPING_CLASSIFIER = "@{artifactId}@-@{baseVersion}@-@{classifier}@.@{extension}@";

    private MappingUtils() {
    }

    public static String evaluateFileNameMapping(String expression, Artifact artifact) throws InterpolationException {
        String value = expression;
        RegexBasedInterpolator interpolator = new RegexBasedInterpolator("\\@\\{(", ")?([^}]+)\\}@");
        interpolator.addValueSource((ValueSource)new ObjectBasedValueSource((Object)artifact));
        interpolator.addValueSource((ValueSource)new ObjectBasedValueSource((Object)artifact.getArtifactHandler()));
        interpolator.addValueSource((ValueSource)new DashClassifierValueSource(artifact.getClassifier()));
        value = interpolator.interpolate(value, "__artifact");
        return value;
    }
}

