/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency.graph.traversal;

import java.util.ArrayList;
import java.util.Stack;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.internal.DefaultDependencyNode;
import org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor;

public class BuildingDependencyNodeVisitor
implements DependencyNodeVisitor {
    private final DependencyNodeVisitor visitor;
    private final Stack<DependencyNode> parentNodes;
    private DependencyNode rootNode;

    public BuildingDependencyNodeVisitor() {
        this(null);
    }

    public BuildingDependencyNodeVisitor(DependencyNodeVisitor visitor) {
        this.visitor = visitor;
        this.parentNodes = new Stack();
    }

    public boolean visit(DependencyNode node) {
        DefaultDependencyNode newNode = new DefaultDependencyNode(this.parentNodes.isEmpty() ? null : this.parentNodes.peek(), node.getArtifact(), node.getPremanagedVersion(), node.getPremanagedScope(), node.getVersionConstraint());
        newNode.setChildren(new ArrayList<DependencyNode>());
        if (this.parentNodes.empty()) {
            this.rootNode = newNode;
        } else {
            DependencyNode parentNode = this.parentNodes.peek();
            parentNode.getChildren().add(newNode);
        }
        this.parentNodes.push(newNode);
        return true;
    }

    public boolean endVisit(DependencyNode node) {
        this.parentNodes.pop();
        if (this.parentNodes.empty() && this.visitor != null) {
            this.rootNode.accept(this.visitor);
        }
        return true;
    }

    public DependencyNodeVisitor getDependencyNodeVisitor() {
        return this.visitor;
    }

    public DependencyNode getDependencyTree() {
        return this.rootNode;
    }
}

