/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.idea;

import java.io.File;
import java.io.IOException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.idea.AbstractIdeaMojo;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class IdeaWorkspaceMojo
extends AbstractIdeaMojo {
    private String workspaceTemplatePath;

    public void initParam(MavenProject executedProject, ArtifactFactory artifactFactory, ArtifactRepository localRepo, ArtifactResolver artifactResolver, ArtifactMetadataSource artifactMetadataSource, Log log, boolean overwrite, String workspaceTemplatePath) {
        super.initParam(executedProject, artifactFactory, localRepo, artifactResolver, artifactMetadataSource, log, overwrite);
        this.workspaceTemplatePath = workspaceTemplatePath;
    }

    public void execute() throws MojoExecutionException {
        try {
            this.doDependencyResolution(this.executedProject, this.localRepo);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to build project dependencies.", e);
        }
        this.rewriteWorkspace();
    }

    public void rewriteWorkspace() throws MojoExecutionException {
        File targetWorkspaceFile = new File(this.executedProject.getBasedir(), this.executedProject.getArtifactId() + ".iws");
        if (!targetWorkspaceFile.exists()) {
            this.getLog().info((CharSequence)("Configuration for workspaceTemplatePath specified: " + this.workspaceTemplatePath));
            if (this.workspaceTemplatePath != null && this.workspaceTemplatePath.length() > 0 && new File(this.workspaceTemplatePath).isFile()) {
                File workspaceTemplateFile = new File(this.workspaceTemplatePath);
                try {
                    this.getLog().info((CharSequence)("Workspace template found at " + workspaceTemplateFile));
                    String templateContents = FileUtils.fileRead((File)workspaceTemplateFile);
                    FileUtils.fileWrite((String)targetWorkspaceFile.getAbsolutePath(), (String)templateContents);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Error reading IWS file: " + workspaceTemplateFile.getAbsolutePath(), (Exception)e);
                }
            } else {
                try {
                    Document document = this.readXmlDocument(targetWorkspaceFile, "workspace.xml");
                    Element module = document.getRootElement();
                    this.setProjectScmType(module);
                    this.writeXmlDocument(targetWorkspaceFile, document);
                }
                catch (DocumentException e) {
                    throw new MojoExecutionException("Error parsing existing IWS file: " + targetWorkspaceFile.getAbsolutePath(), (Exception)((Object)e));
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Unable to create workspace file", (Exception)e);
                }
            }
        } else {
            this.getLog().info((CharSequence)("Existing workspace file found at " + targetWorkspaceFile.getAbsolutePath() + " ignoring."));
        }
    }

    private void setProjectScmType(Element content) {
        String scmType = this.getScmType();
        if (scmType != null) {
            Element component = this.findComponent(content, "VcsManagerConfiguration");
            Element element = this.findElement(component, "option", "ACTIVE_VCS_NAME");
            element.addAttribute("value", scmType);
        }
    }

    protected String getScmType() {
        if (this.executedProject.getScm() == null) {
            return null;
        }
        String scmType = this.getScmType(this.executedProject.getScm().getConnection());
        if (scmType != null) {
            return scmType;
        }
        scmType = this.getScmType(this.executedProject.getScm().getDeveloperConnection());
        return scmType;
    }

    protected String getScmType(String connection) {
        if (connection != null && connection.length() > 0) {
            int startIndex = connection.indexOf(":");
            int endIndex = connection.indexOf("|", startIndex + 1);
            if (endIndex == -1) {
                endIndex = connection.indexOf(":", startIndex + 1);
            }
            if (startIndex < endIndex) {
                String scmType = connection.substring(startIndex + 1, endIndex);
                scmType = this.translateScmType(scmType);
                return scmType;
            }
        }
        return null;
    }

    protected String translateScmType(String scmType) {
        if ("cvs".equals(scmType)) {
            return "CVS";
        }
        if ("perforce".equals(scmType)) {
            return "Perforce";
        }
        if ("starteam".equals(scmType)) {
            return "StarTeam";
        }
        if ("vss".equals(scmType)) {
            return "SourceSafe";
        }
        return scmType;
    }
}

