/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.deploy;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.deploy.AbstractDeployMojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.ProjectArtifact;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.deployment.DeployRequest;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.util.artifact.SubArtifact;

@Mojo(name="deploy", defaultPhase=LifecyclePhase.DEPLOY, threadSafe=true)
public class DeployMojo
extends AbstractDeployMojo {
    private static final Pattern ALT_LEGACY_REPO_SYNTAX_PATTERN = Pattern.compile("(.+?)::(.+?)::(.+)");
    private static final Pattern ALT_REPO_SYNTAX_PATTERN = Pattern.compile("(.+?)::(.+)");
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${reactorProjects}", required=true, readonly=true)
    private List<MavenProject> reactorProjects;
    @Parameter(defaultValue="${plugin}", required=true, readonly=true)
    private PluginDescriptor pluginDescriptor;
    @Parameter(defaultValue="false", property="deployAtEnd")
    private boolean deployAtEnd;
    @Parameter(property="altDeploymentRepository")
    private String altDeploymentRepository;
    @Parameter(property="altSnapshotDeploymentRepository")
    private String altSnapshotDeploymentRepository;
    @Parameter(property="altReleaseDeploymentRepository")
    private String altReleaseDeploymentRepository;
    @Parameter(property="maven.deploy.skip", defaultValue="false")
    private String skip = Boolean.FALSE.toString();
    private static final String DEPLOY_PROCESSED_MARKER = DeployMojo.class.getName() + ".processed";
    private static final String DEPLOY_ALT_RELEASE_DEPLOYMENT_REPOSITORY = DeployMojo.class.getName() + ".altReleaseDeploymentRepository";
    private static final String DEPLOY_ALT_SNAPSHOT_DEPLOYMENT_REPOSITORY = DeployMojo.class.getName() + ".altSnapshotDeploymentRepository";
    private static final String DEPLOY_ALT_DEPLOYMENT_REPOSITORY = DeployMojo.class.getName() + ".altDeploymentRepository";

    private void putState(State state) {
        this.getPluginContext().put(DEPLOY_PROCESSED_MARKER, state.name());
    }

    private void putPluginContextValue(String key, String value) {
        if (value != null) {
            this.getPluginContext().put(key, value);
        }
    }

    private String getPluginContextValue(Map<String, Object> pluginContext, String key) {
        return (String)pluginContext.get(key);
    }

    private State getState(Map<String, Object> pluginContext) {
        return State.valueOf(this.getPluginContextValue(pluginContext, DEPLOY_PROCESSED_MARKER));
    }

    private boolean hasState(MavenProject project) {
        Map pluginContext = this.session.getPluginContext(this.pluginDescriptor, project);
        return pluginContext.containsKey(DEPLOY_PROCESSED_MARKER);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (Boolean.parseBoolean(this.skip) || "releases".equals(this.skip) && !ArtifactUtils.isSnapshot((String)this.project.getVersion()) || "snapshots".equals(this.skip) && ArtifactUtils.isSnapshot((String)this.project.getVersion())) {
            this.getLog().info((CharSequence)"Skipping artifact deployment");
            this.putState(State.SKIPPED);
        } else {
            this.failIfOffline();
            this.warnIfAffectedPackagingAndMaven(this.project.getPackaging());
            if (!this.deployAtEnd) {
                this.deploy(this.session.getRepositorySession(), this.processProject(this.project, this.altSnapshotDeploymentRepository, this.altReleaseDeploymentRepository, this.altDeploymentRepository));
                this.putState(State.DEPLOYED);
            } else {
                this.putPluginContextValue(DEPLOY_ALT_RELEASE_DEPLOYMENT_REPOSITORY, this.altReleaseDeploymentRepository);
                this.putPluginContextValue(DEPLOY_ALT_SNAPSHOT_DEPLOYMENT_REPOSITORY, this.altSnapshotDeploymentRepository);
                this.putPluginContextValue(DEPLOY_ALT_DEPLOYMENT_REPOSITORY, this.altDeploymentRepository);
                this.putState(State.TO_BE_DEPLOYED);
                this.getLog().info((CharSequence)("Deferring deploy for " + this.project.getGroupId() + ":" + this.project.getArtifactId() + ":" + this.project.getVersion() + " at end"));
            }
        }
        if (this.allProjectsMarked()) {
            for (MavenProject reactorProject : this.reactorProjects) {
                Map pluginContext = this.session.getPluginContext(this.pluginDescriptor, reactorProject);
                State state = this.getState(pluginContext);
                if (state != State.TO_BE_DEPLOYED) continue;
                String altReleaseDeploymentRepository = this.getPluginContextValue(pluginContext, DEPLOY_ALT_RELEASE_DEPLOYMENT_REPOSITORY);
                String altSnapshotDeploymentRepository = this.getPluginContextValue(pluginContext, DEPLOY_ALT_SNAPSHOT_DEPLOYMENT_REPOSITORY);
                String altDeploymentRepository = this.getPluginContextValue(pluginContext, DEPLOY_ALT_DEPLOYMENT_REPOSITORY);
                this.deploy(this.session.getRepositorySession(), this.processProject(reactorProject, altSnapshotDeploymentRepository, altReleaseDeploymentRepository, altDeploymentRepository));
            }
        }
    }

    private boolean allProjectsMarked() {
        for (MavenProject reactorProject : this.reactorProjects) {
            if (this.hasState(reactorProject)) continue;
            return false;
        }
        return true;
    }

    private DeployRequest processProject(MavenProject project, String altSnapshotDeploymentRepository, String altReleaseDeploymentRepository, String altDeploymentRepository) throws MojoExecutionException, MojoFailureException {
        DeployRequest request = new DeployRequest();
        request.setRepository(this.getDeploymentRepository(project, altSnapshotDeploymentRepository, altReleaseDeploymentRepository, altDeploymentRepository));
        org.apache.maven.artifact.Artifact mavenMainArtifact = project.getArtifact();
        String packaging = project.getPackaging();
        File pomFile = project.getFile();
        boolean isPomArtifact = "pom".equals(packaging);
        boolean pomArtifactAttached = false;
        if (pomFile != null) {
            request.addArtifact(RepositoryUtils.toArtifact((org.apache.maven.artifact.Artifact)new ProjectArtifact(project)));
            pomArtifactAttached = true;
        }
        if (!isPomArtifact) {
            File file = mavenMainArtifact.getFile();
            if (file != null && file.isFile()) {
                Artifact mainArtifact = RepositoryUtils.toArtifact((org.apache.maven.artifact.Artifact)mavenMainArtifact);
                request.addArtifact(mainArtifact);
                if (!pomArtifactAttached) {
                    for (Object metadata : mavenMainArtifact.getMetadataList()) {
                        if (!(metadata instanceof ProjectArtifactMetadata)) continue;
                        request.addArtifact(new SubArtifact(mainArtifact, "", "pom").setFile(((ProjectArtifactMetadata)metadata).getFile()));
                        pomArtifactAttached = true;
                    }
                }
            } else {
                if (!project.getAttachedArtifacts().isEmpty()) {
                    throw new MojoExecutionException("The packaging plugin for this project did not assign a main file to the project but it has attachments. Change packaging to 'pom'.");
                }
                throw new MojoExecutionException("The packaging for this project did not assign a file to the build artifact");
            }
        }
        if (!pomArtifactAttached) {
            throw new MojoExecutionException("The POM could not be attached");
        }
        for (org.apache.maven.artifact.Artifact attached : project.getAttachedArtifacts()) {
            this.getLog().debug((CharSequence)("Attaching for install: " + attached.getId()));
            request.addArtifact(RepositoryUtils.toArtifact((org.apache.maven.artifact.Artifact)attached));
        }
        return request;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    RemoteRepository getDeploymentRepository(MavenProject project, String altSnapshotDeploymentRepository, String altReleaseDeploymentRepository, String altDeploymentRepository) throws MojoExecutionException, MojoFailureException {
        RemoteRepository repo = null;
        String altDeploymentRepo = ArtifactUtils.isSnapshot((String)project.getVersion()) && altSnapshotDeploymentRepository != null ? altSnapshotDeploymentRepository : (!ArtifactUtils.isSnapshot((String)project.getVersion()) && altReleaseDeploymentRepository != null ? altReleaseDeploymentRepository : altDeploymentRepository);
        if (altDeploymentRepo != null) {
            this.getLog().info((CharSequence)("Using alternate deployment repository " + altDeploymentRepo));
            Matcher matcher = ALT_LEGACY_REPO_SYNTAX_PATTERN.matcher(altDeploymentRepo);
            if (matcher.matches()) {
                String id = matcher.group(1).trim();
                String layout = matcher.group(2).trim();
                String url = matcher.group(3).trim();
                if (!"default".equals(layout)) throw new MojoFailureException((Object)altDeploymentRepo, "Invalid legacy syntax and layout for repository.", "Invalid legacy syntax and layout for alternative repository. Use \"" + id + "::" + url + "\" instead, and only default layout is supported.");
                this.getLog().warn((CharSequence)("Using legacy syntax for alternative repository. Use \"" + id + "::" + url + "\" instead."));
                repo = this.getRemoteRepository(id, url);
            } else {
                matcher = ALT_REPO_SYNTAX_PATTERN.matcher(altDeploymentRepo);
                if (!matcher.matches()) {
                    throw new MojoFailureException((Object)altDeploymentRepo, "Invalid syntax for repository.", "Invalid syntax for alternative repository. Use \"id::url\".");
                }
                String id = matcher.group(1).trim();
                String url = matcher.group(2).trim();
                repo = this.getRemoteRepository(id, url);
            }
        }
        if (repo == null) {
            repo = RepositoryUtils.toRepo((ArtifactRepository)project.getDistributionManagementArtifactRepository());
        }
        if (repo != null) return repo;
        String msg = "Deployment failed: repository element was not specified in the POM inside distributionManagement element or in -DaltDeploymentRepository=id::url parameter";
        throw new MojoExecutionException(msg);
    }

    private static enum State {
        SKIPPED,
        DEPLOYED,
        TO_BE_DEPLOYED;

    }
}

