/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.dependency;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.shared.artifact.filter.PatternExcludesArtifactFilter;
import org.apache.maven.shared.artifact.filter.PatternIncludesArtifactFilter;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="purge-local-repository", threadSafe=true)
public class PurgeLocalRepositoryMojo
extends AbstractMojo {
    public static final String FILE_FUZZINESS = "file";
    public static final String VERSION_FUZZINESS = "version";
    public static final String ARTIFACT_ID_FUZZINESS = "artifactId";
    public static final String GROUP_ID_FUZZINESS = "groupId";
    @Component
    private MavenProject project;
    @Parameter
    private List<String> manualIncludes;
    @Parameter(property="manualInclude")
    private String manualInclude;
    @Parameter
    private List<String> includes;
    @Parameter(property="include")
    private String include;
    @Parameter
    private List<String> excludes;
    @Parameter(property="exclude")
    private String exclude;
    @Parameter(property="reResolve", defaultValue="true")
    private boolean reResolve;
    @Parameter(defaultValue="${localRepository}", readonly=true, required=true)
    private ArtifactRepository localRepository;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true, required=true)
    protected List<ArtifactRepository> remoteRepositories;
    @Component
    private ArtifactResolver resolver;
    @Component
    private ArtifactMetadataSource metadataSource;
    @Parameter(property="resolutionFuzziness", defaultValue="version")
    private String resolutionFuzziness;
    @Parameter(property="actTransitively", defaultValue="true")
    private boolean actTransitively;
    @Component
    private ArtifactFactory factory;
    @Parameter(property="verbose", defaultValue="false")
    private boolean verbose;
    @Parameter(property="snapshotsOnly", defaultValue="false")
    private boolean snapshotsOnly;
    @Parameter(property="skip", defaultValue="false")
    private boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isSkip()) {
            this.getLog().info((CharSequence)"Skipping plugin execution");
            return;
        }
        if (!StringUtils.isEmpty((String)this.manualInclude)) {
            this.manualIncludes = this.parseIncludes(this.manualInclude);
        }
        if (this.manualIncludes != null && this.manualIncludes.size() > 0) {
            this.manualPurge(this.manualIncludes);
            return;
        }
        Set dependencyArtifacts = null;
        try {
            dependencyArtifacts = this.project.createArtifacts(this.factory, null, null);
        }
        catch (InvalidDependencyVersionException e) {
            throw new MojoFailureException("Unable to purge dependencies due to invalid dependency version ", (Throwable)e);
        }
        ArtifactFilter artifactFilter = this.createPurgeArtifactsFilter(dependencyArtifacts);
        Set<Artifact> resolvedArtifactsToPurge = this.getFilteredResolvedArtifacts(this.project, dependencyArtifacts, artifactFilter);
        if (resolvedArtifactsToPurge.isEmpty()) {
            this.getLog().info((CharSequence)("No artifacts included for purge for project: " + this.project.getId()));
            return;
        }
        this.verbose("Purging dependencies for project: " + this.project.getId());
        this.purgeArtifacts(resolvedArtifactsToPurge);
        if (this.reResolve) {
            try {
                this.reResolveArtifacts(this.project, resolvedArtifactsToPurge, artifactFilter);
            }
            catch (ArtifactResolutionException e) {
                String failureMessage = "Failed to refresh project dependencies for: " + this.project.getId();
                MojoFailureException failure = new MojoFailureException(failureMessage);
                failure.initCause((Throwable)e);
                throw failure;
            }
            catch (ArtifactNotFoundException e) {
                String failureMessage = "Failed to refresh project dependencies for: " + this.project.getId();
                MojoFailureException failure = new MojoFailureException(failureMessage);
                failure.initCause((Throwable)e);
                throw failure;
            }
        }
    }

    private void manualPurge(List<String> includes) throws MojoExecutionException {
        for (String gavPattern : includes) {
            File purgeDir;
            if (StringUtils.isEmpty((String)gavPattern)) {
                this.getLog().debug((CharSequence)("Skipping empty gav pattern: " + gavPattern));
                continue;
            }
            String relativePath = this.gavToPath(gavPattern);
            if (StringUtils.isEmpty((String)relativePath) || !(purgeDir = new File(this.localRepository.getBasedir(), relativePath)).exists()) continue;
            this.getLog().debug((CharSequence)("Deleting directory: " + purgeDir));
            try {
                FileUtils.deleteDirectory((File)purgeDir);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to purge directory: " + purgeDir);
            }
        }
    }

    private String gavToPath(String gav) {
        if (StringUtils.isEmpty((String)gav)) {
            return null;
        }
        String[] pathComponents = gav.split(":");
        StringBuffer path = new StringBuffer(pathComponents[0].replace('.', '/'));
        for (int i = 1; i < pathComponents.length; ++i) {
            path.append("/" + pathComponents[i]);
        }
        return path.toString();
    }

    private ArtifactFilter createPurgeArtifactsFilter(Set<Artifact> dependencyArtifacts) {
        AndArtifactFilter andFilter = new AndArtifactFilter();
        andFilter.add((ArtifactFilter)new SystemScopeExcludeFilter());
        if (this.snapshotsOnly) {
            andFilter.add((ArtifactFilter)new SnapshotsFilter());
        }
        if (!StringUtils.isEmpty((String)this.include)) {
            this.includes = this.parseIncludes(this.include);
        }
        if (this.includes != null) {
            andFilter.add((ArtifactFilter)new PatternIncludesArtifactFilter(this.includes));
        }
        if (!StringUtils.isEmpty((String)this.exclude)) {
            this.excludes = this.parseIncludes(this.exclude);
        }
        if (this.excludes != null) {
            andFilter.add((ArtifactFilter)new PatternExcludesArtifactFilter(this.excludes));
        }
        if (!this.actTransitively) {
            andFilter.add((ArtifactFilter)new DirectDependencyFilter(this.project.getArtifact(), dependencyArtifacts));
        }
        return andFilter;
    }

    private List<String> parseIncludes(String include) {
        ArrayList<String> includes = new ArrayList<String>();
        if (include != null) {
            String[] elements = include.split(",");
            includes.addAll(Arrays.asList(elements));
        }
        return includes;
    }

    private Set<Artifact> getFilteredResolvedArtifacts(MavenProject project, Set<Artifact> artifacts, ArtifactFilter filter) {
        try {
            ArtifactResolutionResult result = this.resolver.resolveTransitively(artifacts, project.getArtifact(), this.localRepository, this.remoteRepositories, this.metadataSource, filter);
            Set resolvedArtifacts = result.getArtifacts();
            return resolvedArtifacts;
        }
        catch (ArtifactResolutionException e) {
            this.getLog().info((CharSequence)("Unable to resolve all dependencies for : " + e.getGroupId() + ":" + e.getArtifactId() + ":" + e.getVersion() + ". Falling back to non-transitive mode for initial artifact resolution."));
        }
        catch (ArtifactNotFoundException e) {
            this.getLog().info((CharSequence)("Unable to resolve all dependencies for : " + e.getGroupId() + ":" + e.getArtifactId() + ":" + e.getVersion() + ". Falling back to non-transitive mode for initial artifact resolution."));
        }
        LinkedHashSet<Artifact> resolvedArtifacts = new LinkedHashSet<Artifact>();
        for (Artifact artifact : artifacts) {
            if (!filter.include(artifact)) continue;
            try {
                resolvedArtifacts.add(artifact);
                this.resolver.resolve(artifact, this.remoteRepositories, this.localRepository);
            }
            catch (ArtifactResolutionException e) {
                this.getLog().debug((CharSequence)("Unable to resolve artifact: " + artifact));
            }
            catch (ArtifactNotFoundException e) {
                this.getLog().debug((CharSequence)("Unable to resolve artifact: " + artifact));
            }
        }
        return resolvedArtifacts;
    }

    private void purgeArtifacts(Set<Artifact> artifacts) throws MojoFailureException {
        for (Artifact artifact : artifacts) {
            this.verbose("Purging artifact: " + artifact.getId());
            File deleteTarget = this.findDeleteTarget(artifact);
            this.verbose("Deleting: " + deleteTarget);
            if (deleteTarget.isDirectory()) {
                try {
                    FileUtils.deleteDirectory((File)deleteTarget);
                }
                catch (IOException e) {
                    this.getLog().warn((CharSequence)("Unable to purge local repository location: " + deleteTarget), (Throwable)e);
                }
            } else if (!deleteTarget.delete()) {
                this.getLog().warn((CharSequence)("Unable to purge local repository location: " + deleteTarget));
            }
            artifact.setResolved(false);
        }
    }

    private void reResolveArtifacts(MavenProject project, Set<Artifact> artifacts, ArtifactFilter filter) throws ArtifactResolutionException, ArtifactNotFoundException {
        for (Artifact artifact : artifacts) {
            try {
                Artifact pomArtifact = this.factory.createArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), null, "pom");
                this.resolver.resolveAlways(pomArtifact, this.remoteRepositories, this.localRepository);
            }
            catch (ArtifactResolutionException e) {
                this.verbose(e.getMessage());
            }
            catch (ArtifactNotFoundException e) {
                this.verbose(e.getMessage());
            }
        }
        ArrayList<Artifact> missingArtifacts = new ArrayList<Artifact>();
        for (Artifact artifact : artifacts) {
            this.verbose("Resolving artifact: " + artifact.getId());
            try {
                this.resolver.resolveAlways(artifact, project.getRemoteArtifactRepositories(), this.localRepository);
            }
            catch (ArtifactResolutionException e) {
                this.verbose(e.getMessage());
                missingArtifacts.add(artifact);
            }
            catch (ArtifactNotFoundException e) {
                this.verbose(e.getMessage());
                missingArtifacts.add(artifact);
            }
        }
        if (missingArtifacts.size() > 0) {
            String message = "required artifacts missing:\n";
            for (Artifact missingArtifact : missingArtifacts) {
                message = message + "  " + missingArtifact.getId() + "\n";
            }
            message = message + "\nfor the artifact:";
            throw new ArtifactResolutionException(message, project.getArtifact(), project.getRemoteArtifactRepositories());
        }
    }

    private File findDeleteTarget(Artifact artifact) {
        File deleteTarget = new File(this.localRepository.getBasedir(), this.localRepository.pathOf(artifact));
        if (GROUP_ID_FUZZINESS.equals(this.resolutionFuzziness)) {
            deleteTarget = deleteTarget.getParentFile().getParentFile().getParentFile();
        } else if (ARTIFACT_ID_FUZZINESS.equals(this.resolutionFuzziness)) {
            deleteTarget = deleteTarget.getParentFile().getParentFile();
        } else if (VERSION_FUZZINESS.equals(this.resolutionFuzziness)) {
            deleteTarget = deleteTarget.getParentFile();
        }
        return deleteTarget;
    }

    private void verbose(String message) {
        if (this.verbose || this.getLog().isDebugEnabled()) {
            this.getLog().info((CharSequence)message);
        }
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    private class SnapshotsFilter
    implements ArtifactFilter {
        private SnapshotsFilter() {
        }

        public boolean include(Artifact artifact) {
            return artifact.isSnapshot();
        }
    }

    private class SystemScopeExcludeFilter
    implements ArtifactFilter {
        private SystemScopeExcludeFilter() {
        }

        public boolean include(Artifact artifact) {
            return !"system".equals(artifact.getScope());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DirectDependencyFilter
    implements ArtifactFilter {
        private Artifact projectArtifact;
        private Set<Artifact> directDependencyArtifacts;

        public DirectDependencyFilter(Artifact projectArtifact, Set<Artifact> directDependencyArtifacts) {
            this.projectArtifact = projectArtifact;
            this.directDependencyArtifacts = directDependencyArtifacts;
        }

        public boolean include(Artifact artifact) {
            if (this.artifactsGAMatch(artifact, this.projectArtifact)) {
                return true;
            }
            for (Artifact depArtifact : this.directDependencyArtifacts) {
                if (!this.artifactsGAMatch(artifact, depArtifact)) continue;
                return true;
            }
            return false;
        }

        private boolean artifactsGAMatch(Artifact artifact1, Artifact artifact2) {
            if (artifact1 == artifact2) {
                return true;
            }
            if (!artifact1.getGroupId().equals(artifact2.getGroupId())) {
                PurgeLocalRepositoryMojo.this.getLog().debug((CharSequence)("Different groupId: " + artifact1 + "  " + artifact2));
                return false;
            }
            if (!artifact1.getArtifactId().equals(artifact2.getArtifactId())) {
                PurgeLocalRepositoryMojo.this.getLog().debug((CharSequence)("Different artifactId: " + artifact1 + "  " + artifact2));
                return false;
            }
            return true;
        }
    }
}

