/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.nosql.appender.couchdb;

import java.util.Map;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.apache.logging.log4j.nosql.appender.AbstractNoSqlConnection;
import org.apache.logging.log4j.nosql.appender.DefaultNoSqlObject;
import org.apache.logging.log4j.nosql.appender.NoSqlObject;
import org.apache.logging.log4j.util.Strings;
import org.lightcouch.CouchDbClient;
import org.lightcouch.Response;

public final class CouchDbConnection
extends AbstractNoSqlConnection<Map<String, Object>, DefaultNoSqlObject> {
    private final CouchDbClient client;

    public CouchDbConnection(CouchDbClient client) {
        this.client = client;
    }

    @Override
    public DefaultNoSqlObject createObject() {
        return new DefaultNoSqlObject();
    }

    public DefaultNoSqlObject[] createList(int length) {
        return new DefaultNoSqlObject[length];
    }

    @Override
    public void insertObject(NoSqlObject<Map<String, Object>> object) {
        try {
            Response response = this.client.save(object.unwrap());
            if (Strings.isNotEmpty((CharSequence)response.getError())) {
                throw new AppenderLoggingException("Failed to write log event to CouchDB due to error: " + response.getError() + '.');
            }
        }
        catch (Exception e) {
            throw new AppenderLoggingException("Failed to write log event to CouchDB due to error: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected void closeImpl() {
        this.client.shutdown();
    }
}

