/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.nosql.appender.mongodb;

import com.mongodb.DB;
import com.mongodb.MongoClient;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.util.Loader;
import org.apache.logging.log4j.core.util.NameUtil;
import org.apache.logging.log4j.nosql.appender.NoSqlProvider;
import org.apache.logging.log4j.nosql.appender.mongodb.MongoDbConnection;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Strings;

@Plugin(name="MongoDb", category="Core", printObject=true)
public final class MongoDbProvider
implements NoSqlProvider<MongoDbConnection> {
    private static final WriteConcern DEFAULT_WRITE_CONCERN = WriteConcern.ACKNOWLEDGED;
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final String collectionName;
    private final DB database;
    private final String description;
    private final WriteConcern writeConcern;

    private MongoDbProvider(DB database, WriteConcern writeConcern, String collectionName, String description) {
        this.database = database;
        this.writeConcern = writeConcern;
        this.collectionName = collectionName;
        this.description = "mongoDb{ " + description + " }";
    }

    @Override
    public MongoDbConnection getConnection() {
        return new MongoDbConnection(this.database, this.writeConcern, this.collectionName);
    }

    @Override
    public String toString() {
        return this.description;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PluginFactory
    public static MongoDbProvider createNoSqlProvider(@PluginAttribute(value="collectionName") String collectionName, @PluginAttribute(value="writeConcernConstant") String writeConcernConstant, @PluginAttribute(value="writeConcernConstantClass") String writeConcernConstantClassName, @PluginAttribute(value="databaseName") String databaseName, @PluginAttribute(value="server") String server, @PluginAttribute(value="port") String port, @PluginAttribute(value="userName") String userName, @PluginAttribute(value="password", sensitive=true) String password, @PluginAttribute(value="factoryClassName") String factoryClassName, @PluginAttribute(value="factoryMethodName") String factoryMethodName) {
        String description;
        DB database;
        block23: {
            if (Strings.isNotEmpty((CharSequence)factoryClassName) && Strings.isNotEmpty((CharSequence)factoryMethodName)) {
                try {
                    Class factoryClass = Loader.loadClass((String)factoryClassName);
                    Method method = factoryClass.getMethod(factoryMethodName, new Class[0]);
                    Object object = method.invoke(null, new Object[0]);
                    if (object instanceof DB) {
                        database = (DB)object;
                    } else if (object instanceof MongoClient) {
                        if (!Strings.isNotEmpty((CharSequence)databaseName)) {
                            LOGGER.error("The factory method [{}.{}()] returned a MongoClient so the database name is required.", (Object)factoryClassName, (Object)factoryMethodName);
                            return null;
                        }
                        database = ((MongoClient)object).getDB(databaseName);
                    } else {
                        if (object == null) {
                            LOGGER.error("The factory method [{}.{}()] returned null.", (Object)factoryClassName, (Object)factoryMethodName);
                            return null;
                        }
                        LOGGER.error("The factory method [{}.{}()] returned an unsupported type [{}].", (Object)factoryClassName, (Object)factoryMethodName, (Object)object.getClass().getName());
                        return null;
                    }
                    description = "database=" + database.getName();
                    List addresses = database.getMongo().getAllAddress();
                    if (addresses.size() == 1) {
                        description = description + ", server=" + ((ServerAddress)addresses.get(0)).getHost() + ", port=" + ((ServerAddress)addresses.get(0)).getPort();
                    }
                    description = description + ", servers=[";
                    for (ServerAddress address : addresses) {
                        description = description + " { " + address.getHost() + ", " + address.getPort() + " } ";
                    }
                    description = description + "]";
                }
                catch (ClassNotFoundException e) {
                    LOGGER.error("The factory class [{}] could not be loaded.", (Object)factoryClassName, (Object)e);
                    return null;
                }
                catch (NoSuchMethodException e) {
                    LOGGER.error("The factory class [{}] does not have a no-arg method named [{}].", (Object)factoryClassName, (Object)factoryMethodName, (Object)e);
                    return null;
                }
                catch (Exception e) {
                    LOGGER.error("The factory method [{}.{}()] could not be invoked.", (Object)factoryClassName, (Object)factoryMethodName, (Object)e);
                    return null;
                }
            } else {
                if (!Strings.isNotEmpty((CharSequence)databaseName)) {
                    LOGGER.error("No factory method was provided so the database name is required.");
                    return null;
                }
                ArrayList<MongoCredential> credentials = new ArrayList<MongoCredential>();
                description = "database=" + databaseName;
                if (Strings.isNotEmpty((CharSequence)userName) && Strings.isNotEmpty((CharSequence)password)) {
                    description = description + ", username=" + userName + ", passwordHash=" + NameUtil.md5((String)(password + MongoDbProvider.class.getName()));
                    credentials.add(MongoCredential.createCredential((String)userName, (String)databaseName, (char[])password.toCharArray()));
                }
                try {
                    if (Strings.isNotEmpty((CharSequence)server)) {
                        int portInt = AbstractAppender.parseInt((String)port, (int)0);
                        description = description + ", server=" + server;
                        if (portInt > 0) {
                            description = description + ", port=" + portInt;
                            database = new MongoClient(new ServerAddress(server, portInt), credentials).getDB(databaseName);
                            break block23;
                        } else {
                            database = new MongoClient(new ServerAddress(server), credentials).getDB(databaseName);
                        }
                        break block23;
                    }
                    database = new MongoClient(new ServerAddress(), credentials).getDB(databaseName);
                }
                catch (Exception e) {
                    LOGGER.error("Failed to obtain a database instance from the MongoClient at server [{}] and port [{}].", (Object)server, (Object)port);
                    return null;
                }
            }
        }
        try {
            database.getCollectionNames();
        }
        catch (Exception e) {
            LOGGER.error("The database is not up, or you are not authenticated, try supplying a username and password to the MongoDB provider.", (Throwable)e);
            return null;
        }
        WriteConcern writeConcern = MongoDbProvider.toWriteConcern(writeConcernConstant, writeConcernConstantClassName);
        return new MongoDbProvider(database, writeConcern, collectionName, description);
    }

    private static WriteConcern toWriteConcern(String writeConcernConstant, String writeConcernConstantClassName) {
        WriteConcern writeConcern;
        if (Strings.isNotEmpty((CharSequence)writeConcernConstant)) {
            if (Strings.isNotEmpty((CharSequence)writeConcernConstantClassName)) {
                try {
                    Class writeConcernConstantClass = Loader.loadClass((String)writeConcernConstantClassName);
                    Field field = writeConcernConstantClass.getField(writeConcernConstant);
                    writeConcern = (WriteConcern)field.get(null);
                }
                catch (Exception e) {
                    LOGGER.error("Write concern constant [{}.{}] not found, using default.", (Object)writeConcernConstantClassName, (Object)writeConcernConstant);
                    writeConcern = DEFAULT_WRITE_CONCERN;
                }
            } else {
                writeConcern = WriteConcern.valueOf((String)writeConcernConstant);
                if (writeConcern == null) {
                    LOGGER.warn("Write concern constant [{}] not found, using default.", (Object)writeConcernConstant);
                    writeConcern = DEFAULT_WRITE_CONCERN;
                }
            }
        } else {
            writeConcern = DEFAULT_WRITE_CONCERN;
        }
        return writeConcern;
    }
}

